/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.ClickHandler;
import com.storedobject.vaadin.HasThemeStyle;
import com.storedobject.vaadin.Icon;
import com.storedobject.vaadin.ThemeStyle;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.shared.Registration;

public class Button
extends com.vaadin.flow.component.button.Button
implements HasThemeStyle {
    private static boolean noIcons = false;

    public Button(String text, ClickHandler clickHandler) {
        this(text, noIcons ? null : text, clickHandler);
    }

    public Button(Component icon, ClickHandler clickHandler) {
        this(null, icon, clickHandler);
    }

    public Button(String text, String icon, ClickHandler clickHandler) {
        this(text, (Component)(icon == null || icon.isEmpty() ? null : new Icon(icon)), clickHandler);
    }

    public Button(String text, Component icon, ClickHandler clickHandler) {
        if (icon != null) {
            this.setIcon(icon);
        }
        if (text != null) {
            this.setText(text);
        }
        this.addClickHandler(clickHandler);
        this.getElement().getStyle().set("cursor", "pointer");
        if (text == null) {
            ThemeStyle.add(this, ThemeStyle.ICON);
        }
    }

    public Button(VaadinIcon icon, ClickHandler clickHandler) {
        this(null, (Component)new Icon(icon), clickHandler);
    }

    public Button(String text, VaadinIcon icon, ClickHandler clickHandler) {
        this(text, (Component)new Icon(icon), clickHandler);
    }

    public Registration addClickHandler(ClickHandler clickHandler) {
        if (clickHandler == null) {
            return null;
        }
        return this.addClickListener(ClickHandler.convert(clickHandler));
    }

    public void setIcon(VaadinIcon icon) {
        this.setIcon((Component)new Icon(icon));
    }

    public void setIcon(String icon) {
        this.setIcon((Component)new Icon(icon));
    }

    public void setIcon(Component icon) {
        if (noIcons) {
            return;
        }
        super.setIcon(icon);
    }

    @Override
    public Button asPrimary() {
        return (Button)HasThemeStyle.super.asPrimary();
    }

    @Override
    public Button asSmall() {
        return (Button)HasThemeStyle.super.asSmall();
    }

    public static void setNoIcons(boolean noIcons) {
        Button.noIcons = noIcons;
    }
}

