/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.helper.ID;
import com.storedobject.vaadin.Breadcrumbs;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class BreadcrumbsTree
extends Composite<VerticalLayout> {
    private final VerticalLayout layout = new VerticalLayout();
    private final List<Node> roots = new ArrayList<Node>();
    private final List<NodeVisibilityListener> listeners = new ArrayList<NodeVisibilityListener>();

    protected VerticalLayout initContent() {
        return this.layout;
    }

    public Node add(String caption, Component component) {
        Node node = BreadcrumbsTree.createRoot(this, caption, component);
        this.roots.add(node);
        return node;
    }

    public boolean remove(Node node) {
        if (this.roots.remove((Object)node)) {
            node.detach();
            return true;
        }
        for (Node n : this.roots) {
            if (!n.remove(node)) continue;
            return true;
        }
        return false;
    }

    public Stream<Node> getRoots() {
        return this.roots.stream();
    }

    public void visit(Consumer<Node> visitor) {
        this.roots.forEach(r -> this.consume((Node)((Object)r), visitor));
    }

    private void consume(Node node, Consumer<Node> visitor) {
        visitor.accept(node);
        node.children.forEach(n -> this.consume((Node)((Object)n), visitor));
    }

    public void clear() {
        while (!this.roots.isEmpty()) {
            this.remove(this.roots.get(0));
        }
    }

    private static Node createRoot(BreadcrumbsTree tree, String caption, Component component) {
        BreadcrumbsTree breadcrumbsTree = tree;
        Objects.requireNonNull(breadcrumbsTree);
        Node root = breadcrumbsTree.new Node(caption, component, null);
        tree.layout.add(new Component[]{root});
        if (component != null) {
            tree.layout.add(new Component[]{component});
        }
        return root;
    }

    private static void addAfter(BreadcrumbsTree tree, Node newOne, Node afterMe) {
        Node am = afterMe.component == null ? afterMe : afterMe.component;
        ArrayList after = new ArrayList();
        tree.layout.getChildren().dropWhile(arg_0 -> BreadcrumbsTree.lambda$addAfter$2((Component)am, arg_0)).skip(1L).forEach(after::add);
        after.forEach(xva$0 -> tree.layout.remove(new Component[]{xva$0}));
        tree.layout.add(new Component[]{newOne});
        if (newOne.component != null) {
            tree.layout.add(new Component[]{newOne.component});
        }
        after.forEach(xva$0 -> tree.layout.add(new Component[]{xva$0}));
    }

    public Registration addNodeVisibilityListener(NodeVisibilityListener listener) {
        assert (listener != null);
        this.listeners.add(listener);
        return (Registration & Serializable)() -> this.listeners.remove(listener);
    }

    private static /* synthetic */ boolean lambda$addAfter$2(Component am, Component c) {
        return c != am;
    }

    public final class Node
    extends Composite<Breadcrumbs> {
        private final long id = ID.newID();
        private final Node parent;
        private final List<Node> children = new ArrayList<Node>();
        private final Breadcrumbs thisCrumb = new Breadcrumbs();
        private final Breadcrumbs.Breadcrumb thisBreadcrumb;
        private final Component component;
        private boolean expanded;
        private final String caption;
        private Object data;

        private Node(String caption, Component component, Node parent) {
            this.parent = parent;
            if (caption == null || ((String)caption).isBlank()) {
                caption = "Node " + this.id;
            }
            this.caption = caption;
            this.component = component;
            this.createParentCrumbs(parent);
            this.thisBreadcrumb = this.thisCrumb.add((String)caption);
            this.thisBreadcrumb.addClickListener((ComponentEventListener & Serializable)e -> {
                if (!this.children.isEmpty()) {
                    if (this.expanded) {
                        this.collapse();
                    } else {
                        this.expand();
                    }
                }
            });
        }

        private void createParentCrumbs(Node parent) {
            if (parent == null) {
                return;
            }
            this.createParentCrumbs(parent.parent);
            Breadcrumbs.Breadcrumb b = this.thisCrumb.add(parent.caption);
            b.getStyle().set("cursor", "pointer");
            b.addClickListener((ComponentEventListener & Serializable)e -> parent.collapse());
        }

        protected Breadcrumbs initContent() {
            return this.thisCrumb;
        }

        public Stream<Node> getNodes() {
            return this.children.stream();
        }

        public void setVisible(boolean visible) {
        }

        private void visible(boolean visible, boolean hideParent) {
            boolean wasVisible = this.isVisible();
            super.setVisible(visible);
            if (this.component != null) {
                this.component.setVisible(visible);
            }
            boolean bl = this.expanded = !visible;
            if (hideParent && this.parent != null) {
                this.hideParent();
            }
            if (this.isVisible() != wasVisible) {
                BreadcrumbsTree.this.listeners.forEach(listener -> listener.nodeVisible(this, !wasVisible));
            }
        }

        private void hideParent() {
            if (this.parent != null) {
                this.parent.visible(false, false);
                this.parent.hideParent();
            }
        }

        private void visible(boolean visible) {
            this.visible(visible, true);
        }

        public void expand() {
            this.expand(true);
        }

        public void collapse() {
            this.expand(false);
        }

        private void expand(boolean expand) {
            this.visible(!expand);
            this.visibleChildren(expand);
        }

        private void visibleChildren(boolean visible) {
            this.children.forEach(c -> {
                c.visible(visible, false);
                if (!visible) {
                    c.visibleChildren(false);
                }
            });
        }

        private Node tailEnd() {
            if (this.children.isEmpty()) {
                return this;
            }
            return this.children.get(this.children.size() - 1).tailEnd();
        }

        public Node add(String caption, Component component) {
            this.thisBreadcrumb.getStyle().set("cursor", "pointer");
            Node child = new Node(caption, component, this);
            BreadcrumbsTree.addAfter(BreadcrumbsTree.this, child, this.tailEnd());
            this.children.add(child);
            if (!this.isTreeExpanded()) {
                child.visible(false, false);
            }
            return child;
        }

        private boolean isTreeExpanded() {
            if (!this.expanded) {
                return false;
            }
            if (this.parent == null) {
                return true;
            }
            return this.parent.isTreeExpanded();
        }

        public boolean remove(Node node) {
            if (this.children.remove((Object)node)) {
                node.detach();
                if (this.children.isEmpty() && this.isTreeExpanded()) {
                    this.expanded = false;
                    this.expand();
                }
                if (this.children.isEmpty()) {
                    this.thisBreadcrumb.getStyle().remove("cursor");
                }
                return true;
            }
            for (Node c : this.children) {
                if (!c.remove(node)) continue;
                return true;
            }
            return false;
        }

        private void detach() {
            this.children.forEach(Node::detach);
            BreadcrumbsTree.this.layout.remove(new Component[]{this});
            if (this.component != null) {
                BreadcrumbsTree.this.layout.remove(new Component[]{this.component});
            }
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return Objects.hashCode(this.id);
        }

        public String getCaption() {
            return this.caption;
        }

        public Component getComponent() {
            return this.component;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }
    }

    public static interface NodeVisibilityListener {
        public void nodeVisible(Node var1, boolean var2);
    }
}

