/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.helper.ID;
import com.storedobject.vaadin.Badge;
import com.storedobject.vaadin.ButtonLayout;
import com.storedobject.vaadin.ClickHandler;
import com.storedobject.vaadin.Clickable;
import com.storedobject.vaadin.Icon;
import com.storedobject.vaadin.ThemeStyle;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class Breadcrumbs
extends Composite<ButtonLayout> {
    private final List<Breadcrumb> breadcrumbs = new ArrayList<Breadcrumb>();
    private final ButtonLayout layout = new ButtonLayout();
    private final ClickHandler clickHandler;

    public Breadcrumbs() {
        this(null);
    }

    public Breadcrumbs(ClickHandler clickHandler) {
        this.clickHandler = clickHandler;
    }

    protected ButtonLayout initContent() {
        return this.layout;
    }

    public Breadcrumb add(String caption) {
        return caption == null ? null : new Breadcrumb(this, caption);
    }

    public void remove() {
        if (!this.breadcrumbs.isEmpty()) {
            this.remove(this.breadcrumbs.get(this.breadcrumbs.size() - 1));
        }
    }

    public void remove(Breadcrumb breadcrumb) {
        if (breadcrumb == null) {
            return;
        }
        int i = this.breadcrumbs.indexOf(breadcrumb);
        if (i < 0) {
            return;
        }
        this.removeInt(i);
    }

    private void removeInt(int i) {
        for (int n = this.breadcrumbs.size() - 1; n >= i; --n) {
            this.breadcrumbs.get(n).remove();
        }
        if (this.clickHandler != null && !this.breadcrumbs.isEmpty()) {
            this.breadcrumbs.get(this.breadcrumbs.size() - 1).disable();
        }
    }

    public void goTo(Breadcrumb breadcrumb) {
        if (breadcrumb == null) {
            return;
        }
        int i = this.breadcrumbs.indexOf(breadcrumb);
        if (i < 0 || i == this.breadcrumbs.size() - 1) {
            return;
        }
        this.goToInt(i);
    }

    private void goToInt(int i) {
        this.removeInt(i + 1);
    }

    public Breadcrumb getParent(Breadcrumb breadcrumb) {
        int i = this.breadcrumbs.indexOf(breadcrumb);
        return i <= 0 ? null : this.breadcrumbs.get(i - 1);
    }

    public Breadcrumb getChild(Breadcrumb breadcrumb) {
        int i = this.breadcrumbs.indexOf(breadcrumb);
        if (i < 0) {
            return null;
        }
        return ++i < this.breadcrumbs.size() ? this.breadcrumbs.get(i) : null;
    }

    public Breadcrumb getHead() {
        return this.breadcrumbs.isEmpty() ? null : this.breadcrumbs.get(0);
    }

    public Stream<Breadcrumb> streamChildren() {
        return this.breadcrumbs.stream();
    }

    public static class Breadcrumb
    extends Badge {
        private final long id = ID.newID();
        private final Breadcrumbs bc;
        private Icon icon;
        private boolean disabled = true;
        private List<BreadcrumbRemovalListener> listeners;

        private Breadcrumb(Breadcrumbs bc, String caption) {
            super(caption, new ThemeStyle[0]);
            this.bc = bc;
            if (!bc.breadcrumbs.isEmpty()) {
                this.icon = new Icon(VaadinIcon.ANGLE_DOUBLE_RIGHT);
                bc.layout.add(new Component[]{this.icon});
                if (bc.clickHandler != null) {
                    bc.breadcrumbs.get(bc.breadcrumbs.size() - 1).enable();
                }
            }
            bc.layout.add(new Component[]{this});
            bc.breadcrumbs.add(this);
            this.disable();
            if (bc.clickHandler != null) {
                new Clickable<Breadcrumb>(this, (ClickHandler & Serializable)e -> this.clicked());
            }
        }

        private void disable() {
            Style style = this.getElement().getStyle();
            style.remove("cursor");
            style.set("color", "grey");
            this.disabled = true;
        }

        private void enable() {
            if (this.bc.clickHandler != null) {
                Style style = this.getElement().getStyle();
                style.set("cursor", "pointer");
                style.remove("color");
                this.disabled = false;
            }
        }

        private void remove() {
            this.bc.breadcrumbs.remove(this);
            this.bc.layout.remove(new Component[]{this});
            if (this.icon != null) {
                this.bc.layout.remove(new Component[]{this.icon});
            }
            if (this.listeners != null) {
                this.listeners.forEach(listener -> listener.removed(this));
            }
        }

        private void clicked() {
            if (!this.disabled && this.bc.clickHandler != null) {
                this.bc.goToInt(this.bc.breadcrumbs.indexOf(this));
                this.bc.clickHandler.clicked((Component)this);
            }
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public int hashCode() {
            return Objects.hashCode(this.id);
        }

        public Registration addRemovalListener(BreadcrumbRemovalListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<BreadcrumbRemovalListener>();
            }
            this.listeners.add(listener);
            return (Registration & Serializable)() -> this.listeners.remove(listener);
        }
    }

    @FunctionalInterface
    public static interface BreadcrumbRemovalListener {
        public void removed(Breadcrumb var1);
    }
}

