/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.dependency.CssImport;

@CssImport(value="./so/hover/styles.css")
public class Box
extends Composite<Component> {
    private static final String BACKGROUND = "var(--lumo-contrast-10pct)";
    private final Component component;

    public Box(Component component) {
        this.component = component;
        this.setBorderStyle("solid");
        this.setBorderWidth(2);
        this.setBorderColor(BACKGROUND);
        this.setPadding(4);
        this.setBorderRadius(5);
    }

    protected Component initContent() {
        return this.component;
    }

    public Component getContent() {
        return this.component;
    }

    public void setHiliteOnHover(boolean hilite) {
        if (hilite) {
            this.component.getElement().getClassList().add((Object)"so-hover");
        } else {
            this.component.getElement().getClassList().remove((Object)"so-hover");
        }
    }

    public void setBorderRadius(int radius) {
        this.setStyle("border-radius", radius + "px");
    }

    public void setBorderWidth(int widthInPixels) {
        this.setBorderWidth(widthInPixels + "px");
    }

    public void setBorderWidth(String widths) {
        this.setStyle("border-width", widths);
    }

    public void setBorderColor(String color) {
        this.setStyle("border-color", color);
    }

    public void setBorderStyle(String style) {
        this.setStyle("border-style", style);
    }

    public void setPadding(int padding) {
        this.setPadding(padding + "px");
    }

    public void setPadding(String paddings) {
        this.setStyle("padding", paddings);
    }

    public void setMargin(int margin) {
        this.setMargin(margin + "px");
    }

    public void setMargin(String margins) {
        this.setStyle("margin", margins);
    }

    public void setStyle(String style, String value) {
        this.getElement().getStyle().set(style, value);
    }

    public void alignSizing() {
        this.setStyle("box-sizing", "border-box");
    }

    public void setReadOnly(boolean readOnly) {
        this.setStyle("background-color", readOnly ? "white" : BACKGROUND);
        this.setBorderStyle(readOnly ? "dotted" : "solid");
    }

    public void setEnabled(boolean enabled) {
        this.setStyle("background", enabled ? BACKGROUND : "white");
    }

    public void grey() {
        this.setReadOnly(false);
    }
}

