/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.util.NumericField;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class BigDecimalField
extends NumericField<BigDecimal> {
    private final int decimals;

    public BigDecimalField() {
        this(null);
    }

    public BigDecimalField(String label) {
        this(label, null);
    }

    public BigDecimalField(String label, BigDecimal initialValue) {
        this(label, initialValue, 6);
    }

    public BigDecimalField(int decimals) {
        this(null, null, decimals);
    }

    public BigDecimalField(BigDecimal initialValue, int decimals) {
        this(null, initialValue, decimals);
    }

    public BigDecimalField(String label, int decimals) {
        this(label, null, decimals);
    }

    public BigDecimalField(String label, BigDecimal initialValue, int decimals) {
        this(label, initialValue, 18, decimals);
    }

    public BigDecimalField(int width, int decimals) {
        this(null, null, width, decimals);
    }

    public BigDecimalField(BigDecimal initialValue, int width, int decimals) {
        this(null, initialValue, width, decimals);
    }

    public BigDecimalField(String label, int width, int decimals) {
        this(label, width, decimals, false, false);
    }

    public BigDecimalField(String label, BigDecimal initialValue, int width, int decimals) {
        this(label, initialValue, width, decimals, false, false);
    }

    public BigDecimalField(int width, int decimals, boolean grouping) {
        this(null, null, width, decimals, grouping);
    }

    public BigDecimalField(BigDecimal initialValue, int width, int decimals, boolean grouping) {
        this(null, initialValue, width, decimals, grouping);
    }

    public BigDecimalField(String label, int width, int decimals, boolean grouping) {
        this(label, null, width, decimals, grouping);
    }

    public BigDecimalField(String label, BigDecimal initialValue, int width, int decimals, boolean grouping) {
        this(label, initialValue, width, decimals, grouping, false);
    }

    public BigDecimalField(int width, int decimals, boolean grouping, boolean allowNegative) {
        this(null, null, width, decimals, grouping, allowNegative);
    }

    public BigDecimalField(BigDecimal initialValue, int width, int decimals, boolean grouping, boolean allowNegative) {
        this(null, initialValue, width, decimals, grouping, allowNegative);
    }

    public BigDecimalField(String label, int width, int decimals, boolean grouping, boolean allowNegative) {
        this(label, null, width, decimals, grouping, allowNegative);
    }

    public BigDecimalField(String label, BigDecimal initialValue, int width, int decimals, boolean grouping, boolean allowNegative) {
        super(BigDecimalField.toBigDecimal(BigDecimal.ZERO, BigDecimalField.decimals(decimals)));
        this.grouping = grouping;
        this.allowNegative = allowNegative;
        this.decimals = BigDecimalField.decimals(decimals);
        this.setLength(width);
        this.setValue(initialValue);
        this.setLabel(label);
    }

    @Override
    protected BigDecimal generateModelValue() {
        return BigDecimalField.toBigDecimal(this.getField().getValue(), this.decimals);
    }

    private static int decimals(int decimals) {
        return decimals < 1 ? 2 : Math.min(decimals, 40);
    }

    @Override
    public void setValue(BigDecimal value) {
        super.setValue(BigDecimalField.toBigDecimal(value, this.decimals));
    }

    @Override
    protected BigDecimal getModelValue(String string) {
        return BigDecimalField.toBigDecimal(string, this.decimals);
    }

    @Override
    public final int getDecimals() {
        return this.decimals;
    }

    @Override
    protected int getDefaultLength() {
        return 18;
    }

    private static BigDecimal toBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        String v = value.toString().trim();
        if (v.length() == 0) {
            return null;
        }
        try {
            return new BigDecimal(v.trim().replace(",", ""));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static BigDecimal toBigDecimal(Object value, int decimals) {
        BigDecimal bd = BigDecimalField.toBigDecimal(value);
        if (bd == null || decimals < 0 || bd.scale() == decimals) {
            return bd;
        }
        try {
            return bd.setScale(decimals, RoundingMode.DOWN);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

