/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.HasBadgeStyle;
import com.storedobject.vaadin.Icon;
import com.storedobject.vaadin.ThemeStyle;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.dom.Element;

public class Badge
extends Span
implements HasBadgeStyle {
    private Icon icon;
    private final Span text = new Span();

    public Badge() {
        this("", ThemeStyle.BADGE);
    }

    public Badge(String text, ThemeStyle ... styles) {
        this.text.setText(text);
        this.add(new Component[]{this.text});
        this.setTheme(styles);
    }

    public Badge(String icon, String text, ThemeStyle ... styles) {
        this(text, styles);
        this.setIcon(icon);
    }

    public Badge(Icon icon, String text, ThemeStyle ... styles) {
        this(text, styles);
        this.setIcon(icon);
    }

    public void setIcon(String icon) {
        if (icon == null || icon.isEmpty()) {
            this.removeIcon();
            return;
        }
        if (this.icon == null) {
            this.icon = new Icon(icon);
            this.getElement().insertChild(0, new Element[]{this.icon.getElement()});
            return;
        }
        this.icon.setIcon(icon);
    }

    public void setIcon(Icon icon) {
        if (icon == null) {
            this.removeIcon();
            return;
        }
        if (this.icon != null) {
            this.remove(new Component[]{this.icon});
        }
        this.icon = icon;
        this.getElement().insertChild(0, new Element[]{icon.getElement()});
    }

    public void removeIcon() {
        if (this.icon != null) {
            this.remove(new Component[]{this.icon});
            this.icon = null;
        }
    }

    public void setText(String text) {
        this.text.setText(text == null ? "" : text);
    }

    public String getText() {
        return this.text.getText();
    }
}

