/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.helper.ID;
import com.storedobject.helper.LitComponent;
import com.storedobject.vaadin.Application;
import com.storedobject.vaadin.Audio;
import com.storedobject.vaadin.MediaCapture;
import com.storedobject.vaadin.util.MediaStreamVariable;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamReceiver;
import com.vaadin.flow.server.StreamVariable;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonFactory;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JreJsonFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AudioCapture
extends Audio
implements MediaCapture {
    private final Mic mic;
    private List<MediaCapture.StatusChangeListener> statusChangeListeners;
    private Application application;

    public AudioCapture() {
        ID.set((Component)this);
        this.mic = new Mic();
        this.getElement().appendChild(new Element[]{this.mic.getElement()});
        this.mic.getElement().setAttribute("audioid", this.getId().orElse(""));
    }

    @Override
    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.application == null) {
            this.getApplication();
        }
        this.mic.recording = (byte)-1;
        HashMap<String, Object> recOpts = new HashMap<String, Object>();
        recOpts.put("video", false);
        recOpts.put("audio", true);
        this.mic.setOptions(recOpts);
    }

    @Override
    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        boolean changed = this.mic.recording == 1;
        this.mic.recording = (byte)-1;
        if (changed) {
            this.fireStatusChange();
        }
    }

    @Override
    public Application getApplication() {
        if (this.application == null) {
            this.application = Application.get();
        }
        return this.application;
    }

    @Override
    public void startRecording(MediaCapture.DataReceiver dataReceiver) {
        this.mic.setReceiver(dataReceiver);
        this.mic.startRecording();
    }

    @Override
    public boolean isRecording() {
        return this.mic.recording == 1;
    }

    @Override
    public void stopRecording() {
        this.mic.stopRecording();
    }

    @Override
    public void stopDevice() {
        this.mic.stopMic();
    }

    @Override
    public Registration addStatusChangeListener(MediaCapture.StatusChangeListener listener) {
        if (listener == null) {
            return null;
        }
        if (this.statusChangeListeners == null) {
            this.statusChangeListeners = new ArrayList<MediaCapture.StatusChangeListener>();
        }
        this.statusChangeListeners.add(listener);
        return (Registration & Serializable)() -> this.statusChangeListeners.remove(listener);
    }

    private void fireStatusChange() {
        if (this.statusChangeListeners != null) {
            this.statusChangeListeners.forEach(l -> l.statusChanged(this));
        }
    }

    @Tag(value="so-audio")
    @JsModule(value="./so/media/audio.js")
    private class Mic
    extends LitComponent {
        private final String STOP_MIC = "stopMic";
        private final String START_RECORDING = "startRecording";
        private byte recording = 0;
        private final List<String> commands = new ArrayList<String>();
        private volatile boolean done = true;
        private String prevCommand;

        private Mic() {
            ID.set((Component)this);
            this.getElement().setAttribute("spanid", "span" + ID.newID());
        }

        @ClientCallable
        private void recordingStatus(int status) {
            this.recording = (byte)status;
            AudioCapture.this.fireStatusChange();
        }

        private void setOptions(Map<String, Object> recordingOptions) {
            JreJsonFactory factory = new JreJsonFactory();
            this.getElement().setPropertyJson("recordingOptions", this.toJson(recordingOptions, (JsonFactory)factory));
        }

        private JsonValue toJson(Map<String, Object> map, JsonFactory factory) {
            JsonObject obj = factory.createObject();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getValue() instanceof Boolean) {
                    obj.put(entry.getKey(), (JsonValue)factory.create(((Boolean)entry.getValue()).booleanValue()));
                    continue;
                }
                if (entry.getValue() instanceof Double) {
                    obj.put(entry.getKey(), (JsonValue)factory.create(((Double)entry.getValue()).doubleValue()));
                    continue;
                }
                if (entry.getValue() instanceof Integer) {
                    obj.put(entry.getKey(), (JsonValue)factory.create((double)((Integer)entry.getValue()).intValue()));
                    continue;
                }
                if (entry.getValue() instanceof String) {
                    obj.put(entry.getKey(), (JsonValue)factory.create((String)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof Map) {
                    obj.put(entry.getKey(), this.toJson((Map)entry.getValue(), factory));
                    continue;
                }
                throw new IllegalArgumentException();
            }
            return obj;
        }

        private void setReceiver(MediaCapture.DataReceiver receiver) {
            this.getElement().setAttribute("target", (AbstractStreamResource)new StreamReceiver(this.getElement().getNode(), "mic" + ID.newID(), (StreamVariable)new MediaStreamVariable(receiver)));
        }

        private void startRecording() {
            this.js("startRecording");
        }

        private void stopRecording() {
            this.js("stopRecording");
        }

        private void stopMic() {
            this.js("stopMic");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ClientCallable
        private void done() {
            List<String> list = this.commands;
            synchronized (list) {
                if (this.commands.isEmpty()) {
                    this.done = true;
                    return;
                }
                this.done = false;
                String command = this.commands.remove(0);
                if (this.commands.contains("stopMic")) {
                    this.done();
                    return;
                }
                this._js(command);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void js(String js) {
            List<String> list = this.commands;
            synchronized (list) {
                if (this.done) {
                    this.done = false;
                    this._js(js);
                    return;
                }
                this.commands.add(js);
            }
        }

        private void _js(String js) {
            switch (js) {
                case "stopMic": {
                    if (!"stopMic".equals(this.prevCommand)) break;
                    this.done();
                    return;
                }
                case "startRecording": {
                    if (AudioCapture.this.isVisible() && this.recording != 1 && !AudioCapture.this.getParent().isEmpty()) break;
                    this.done();
                    return;
                }
            }
            this.executeJS(js, new Serializable[0]);
            this.prevCommand = js;
        }
    }
}

