/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.helper.ID;
import com.storedobject.helper.LitComponent;
import com.storedobject.vaadin.Application;
import com.storedobject.vaadin.ApplicationLayout;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.server.VaadinRequest;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.atmosphere.cpr.ApplicationConfig;

public abstract class ApplicationView
extends Composite<Component>
implements BeforeEnterObserver,
HasDynamicTitle,
ApplicationConfig {
    ApplicationLayout layout;
    private final Application application;
    Locale locale;
    private boolean firstTime = true;
    Map<String, String> queryParams;
    private String url;
    private final Root root = new Root();

    public ApplicationView() {
        this.application = this.createApplication();
    }

    protected void onAttach(AttachEvent attachEvent) {
        Consumer<UI> configurator;
        super.onAttach(attachEvent);
        UI ui = attachEvent.getUI();
        if (this.locale != null) {
            ui.setLocale(this.locale);
        }
        if ((configurator = this.application.getUIConfigurator()) != null) {
            configurator.accept(ui);
        }
        this.application.setUI(ui);
        if (this.firstTime) {
            if (this.application.error != null) {
                this.application.close();
                return;
            }
            this.firstTime = false;
            if (this.layout != null) {
                this.application.setMainView(this);
            }
            this.root.receiveInfo();
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.application.detached();
    }

    final void setLocale(Locale locale) {
        if (locale == null) {
            return;
        }
        this.locale = locale;
        this.getUI().ifPresent(ui -> ui.setLocale(locale));
    }

    protected final Component initContent() {
        if (this.layout == null) {
            if (this.application == null) {
                Notification.show((String)"Logged out");
            } else {
                this.application.init(VaadinRequest.getCurrent());
                if (this.application.error != null) {
                    Notification.show((String)this.application.error);
                }
            }
            if (this.application == null) {
                return new Div();
            }
            if (this.application.error != null) {
                return new Span(this.application.error);
            }
            this.layout = this.application.createLayout();
        }
        this.add(this.layout.getComponent());
        return this.root;
    }

    public void add(Component screen) {
        this.root.add(screen);
    }

    public void setLayoutVisible(boolean visible) {
        Component c = this.layout.getComponent();
        if (c.isVisible() != visible) {
            c.setVisible(visible);
        }
    }

    public int getDeviceHeight() {
        return this.application.getDeviceHeight();
    }

    public int getDeviceWidth() {
        return this.application.getDeviceWidth();
    }

    public String getURL() {
        if (this.url == null) {
            this.root.receiveInfo();
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.url;
    }

    protected Application createApplication() {
        try {
            return (Application)Class.forName(this.getApplicationClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    Application getApplication() {
        return this.application;
    }

    protected String getApplicationClassName() {
        return null;
    }

    public void beforeEnter(BeforeEnterEvent beforeEnterEvent) {
        this.queryParams = new HashMap<String, String>();
        Location location = beforeEnterEvent.getLocation();
        location.getQueryParameters().getParameters().forEach((key, v) -> this.queryParams.put((String)key, (String)v.get(0)));
        if (this.queryParams.isEmpty()) {
            this.queryParams = null;
        }
    }

    public String getPageTitle() {
        return this.application.getCaption();
    }

    @Tag(value="so-page-root")
    @JsModule(value="./so/pageroot/pageroot.js")
    private class Root
    extends LitComponent {
        private Root() {
            this.getElement().setProperty("idContent", "so" + ID.newID());
        }

        @ClientCallable
        private void info(String url) {
            ApplicationView.this.url = url;
        }

        public void add(Component screen) {
            if (screen == null) {
                return;
            }
            this.getElement().appendChild(new Element[]{screen.getElement()});
        }

        private void receiveInfo() {
            this.executeJS("sendInfo", new Serializable[0]);
        }
    }
}

