/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.helper.ID;
import com.storedobject.vaadin.Application;
import com.storedobject.vaadin.ApplicationLayout;
import com.storedobject.vaadin.ApplicationMenu;
import com.storedobject.vaadin.ApplicationMenuItem;
import com.storedobject.vaadin.ButtonLayout;
import com.storedobject.vaadin.HasSize;
import com.storedobject.vaadin.Scrollable;
import com.storedobject.vaadin.View;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.applayout.AppLayout;
import com.vaadin.flow.component.applayout.DrawerToggle;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.dom.Style;
import java.io.Serializable;

@CssImport(value="./so/appframe/styles.css", themeFor="vaadin-app-layout")
public abstract class ApplicationFrame
extends AppLayout
implements ApplicationLayout {
    private ApplicationMenu menu;
    private Component logo;
    private HasText captionComponent;
    private HasText userNameComponent;
    private ButtonLayout toolbox = new ButtonLayout();
    private boolean initialized = false;
    private Focusable<?> menuSearcher;
    private boolean drawer = false;
    private final DrawerToggle drawerToggle = new DrawerToggle();

    public ApplicationFrame() {
        ID.set((Component)this);
    }

    protected ApplicationMenu createMenu() {
        return this.createMenuInt();
    }

    private ApplicationMenu createMenuInt() {
        this.menu = new Menu(this);
        this.addToNavbar(new Component[]{this.drawerToggle});
        Style s = this.drawerToggle.getElement().getStyle();
        s.set("color", "var(--so-menu-drawer-color)");
        s.set("cursor", "pointer");
        Component c = this.getMenuSearcher();
        if (c != null) {
            if (c instanceof Focusable) {
                this.menuSearcher = (Focusable)c;
            }
            c.getElement().getStyle().set("flex-flow", "0");
            this.addToDrawer(c);
        }
        this.addToDrawer((Component)this.menu);
        return this.menu;
    }

    public final void addToDrawer(Component ... components) {
        super.addToDrawer(components);
        this.drawer = true;
    }

    private void noWrap(Component c) {
        Style s = c.getElement().getStyle();
        s.set("display", "block");
        s.set("white-space", "nowrap");
        s.set("overflow", "hidden");
        s.set("text-overflow", "ellipsis");
    }

    private Span filler() {
        Span filler = new Span();
        filler.getElement().getStyle().set("flex-grow", "1");
        return filler;
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (!this.initialized) {
            if (this.menu == null) {
                this.menu = this.createMenu();
            }
            if (this.menu == null) {
                this.menu = this.createMenuInt();
            }
            this.initialized = true;
            if (this.getLogoInt() != null) {
                this.addToNavbar(new Component[]{this.logo});
            }
            if (this.getCaptionComponent() != null && this.captionComponent instanceof Component) {
                this.addToNavbar(true, new Component[]{(Component)this.captionComponent});
                this.noWrap((Component)this.captionComponent);
            }
            this.addToNavbar(new Component[]{this.filler()});
            this.addToNavbar(true, new Component[]{this.filler()});
            if (this.getUserNameComponent() != null && this.userNameComponent instanceof Component) {
                this.addToNavbar(true, new Component[]{(Component)this.userNameComponent});
                this.userNameComponent.getElement().getStyle().set("text-align", "right");
                this.noWrap((Component)this.userNameComponent);
            }
            if (this.getToolbox() != null) {
                Style s = this.toolbox.getStyle();
                s.set("margin-left", "10px");
                s.set("flex-wrap", "nowrap");
                this.addToNavbar(new Component[]{this.toolbox});
            }
        }
        super.onAttach(attachEvent);
        this.styles("--so-header-background", this.getHeaderBackground(), "--so-header-color", this.getHeaderColor(), "--so-menu-width", "max(12vw,17em)", "--vaadin-app-layout-drawer-width", "var(--so-menu-width, 12vw)");
        this.resizeContent();
    }

    private void styles(String ... var_val) {
        UI ui = UI.getCurrent();
        if (ui == null) {
            return;
        }
        Style s = ui.getElement().getStyle();
        for (int i = 0; i < var_val.length - 1; ++i) {
            if (var_val[i + 1] != null) {
                s.set(var_val[i], var_val[i + 1]);
            }
            ++i;
        }
    }

    @Override
    public void resizeContent() {
        ApplicationLayout.super.resizeContent();
        this.styles("--so-header-height", this.getHeaderHeight());
        this.getLogoInt();
    }

    @Override
    public String getCaption() {
        HasText c = this.getCaptionComponent();
        return c == null ? ApplicationLayout.super.getCaption() : c.getText();
    }

    public String getHeaderHeight() {
        return null;
    }

    public String getHeaderBackground() {
        return null;
    }

    public String getHeaderColor() {
        return null;
    }

    @Override
    public String getContentWidth() {
        return "calc(100vw - var(--vaadin-app-layout-drawer-offset-left))";
    }

    @Override
    public String getContentHeight() {
        return "calc(100vh - var(--so-header-height))";
    }

    @Override
    public void setCaption(String caption) {
        if (this.getCaptionComponent() != null) {
            this.captionComponent.setText(caption);
        }
    }

    private Component getLogoInt() {
        if (this.logo == null) {
            this.logo = this.getLogo();
            if (this.logo instanceof com.vaadin.flow.component.HasSize) {
                ((com.vaadin.flow.component.HasSize)this.logo).setHeight("var(--so-header-height)");
            }
        }
        return this.logo;
    }

    public Component getLogo() {
        return null;
    }

    public ButtonLayout getToolbox() {
        if (this.toolbox == null) {
            this.toolbox = new ButtonLayout();
        }
        return this.toolbox;
    }

    public final DrawerToggle getDrawerToggle() {
        return this.drawerToggle;
    }

    protected HasText createCaptionComponent() {
        return null;
    }

    public final HasText getCaptionComponent() {
        if (this.captionComponent == null) {
            this.captionComponent = this.createCaptionComponent();
        }
        if (this.captionComponent == null) {
            H2 c = new H2();
            c.getStyle().set("color", "var(--so-header-color)");
            this.captionComponent = c;
        }
        return this.captionComponent;
    }

    protected HasText createUserNameComponent() {
        return null;
    }

    public final HasText getUserNameComponent() {
        if (this.userNameComponent == null) {
            this.userNameComponent = this.createUserNameComponent();
        }
        if (this.userNameComponent == null) {
            this.userNameComponent = new Span();
            this.userNameComponent.getElement().getStyle().set("color", "var(--so-header-color)");
        }
        return this.userNameComponent;
    }

    @Override
    public final Component getComponent() {
        return this;
    }

    @Override
    public final ApplicationMenu getMenu() {
        return this.menu;
    }

    @Override
    public void openMenu() {
        if (this.menu instanceof Menu && ((Menu)this.menu).menuCount == 0) {
            this.closeMenu();
            return;
        }
        this.setDrawerOpened(true);
        if (this.menuSearcher != null && this.menuSearcher instanceof Component && ((Component)this.menuSearcher).isVisible()) {
            this.menuSearcher.focus();
        }
    }

    @Override
    public void closeMenu() {
        this.setDrawerOpened(false);
    }

    @Override
    public void toggleMenu() {
        this.setDrawerOpened(!this.isDrawerOpened());
        if (this.menuSearcher != null && this.isDrawerOpened()) {
            this.menuSearcher.focus();
        }
    }

    public void setDrawerOpened(boolean drawerOpened) {
        if (this.drawer) {
            this.getElement().setProperty("drawerOpened", drawerOpened);
        }
    }

    @Override
    public void viewSelected(View view) {
        if (this.drawer && this.isOverlay()) {
            this.setDrawerOpened(false);
        }
    }

    private static class Menu
    extends Div
    implements ApplicationMenu,
    HasSize {
        private int menuCount = 0;
        private final ApplicationFrame frame;

        public Menu(ApplicationFrame frame) {
            this.frame = frame;
            ID.set((Component)this);
            this.getStyle().set("flex-grow", "1");
            new Scrollable((Component)this);
        }

        @Override
        public void add(ApplicationMenuItem menuItem) {
            ApplicationMenu.super.add(menuItem);
            ++this.menuCount;
        }

        @Override
        public void insert(int position, ApplicationMenuItem menuItem) {
            ApplicationMenu.super.insert(position, menuItem);
            this.top();
            ++this.menuCount;
            if (this.menuCount == 1) {
                this.frame.setDrawerOpened(true);
            }
        }

        @Override
        public void remove(ApplicationMenuItem menuItem) {
            ApplicationMenu.super.remove(menuItem);
            this.top();
            --this.menuCount;
            if (this.menuCount == 0) {
                this.frame.closeMenu();
            }
        }

        private void top() {
            Page p;
            Application a = Application.get();
            if (a != null && (p = a.getPage()) != null) {
                p.executeJs("document.getElementById('" + (String)this.getId().orElse(null) + "').scrollTop=0;", new Serializable[0]);
            }
        }
    }
}

