/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Application;
import com.storedobject.vaadin.ApplicationMenuItem;
import com.storedobject.vaadin.ApplicationMenuItemGroup;
import com.storedobject.vaadin.ExecutableView;
import com.storedobject.vaadin.HTMLGenerator;
import com.storedobject.vaadin.MenuItem;
import com.storedobject.vaadin.ObjectColumnCreator;
import com.storedobject.vaadin.ObjectFieldCreator;

public interface ApplicationEnvironment {
    default public ObjectFieldCreator<?> getObjectFieldCreator() {
        return new ObjectFieldCreator<Object>(this){};
    }

    default public ObjectColumnCreator<?> getObjectColumnCreator() {
        return new ObjectColumnCreator<Object>(this){};
    }

    default public String toString(Object any) {
        if (any == null) {
            return "";
        }
        String s = any.toString();
        return s == null ? "" : s;
    }

    default public String toDisplay(Object any) {
        if (any == null) {
            return "";
        }
        if (Exception.class.isAssignableFrom(any.getClass())) {
            return this.toDisplay(((Exception)any).getMessage());
        }
        if (any instanceof HTMLGenerator) {
            return ((HTMLGenerator)any).getHTML();
        }
        return this.toString(any);
    }

    default public String createLabel(String attributeName) {
        StringBuilder label = new StringBuilder();
        label.append(attributeName.charAt(0));
        for (int i = 1; i < attributeName.length(); ++i) {
            char c = attributeName.charAt(i);
            if (Character.isUpperCase(c)) {
                label.append(' ');
            }
            label.append(c);
        }
        return label.toString();
    }

    default public String createLabel(Class<?> aClass) {
        String s = aClass.getName();
        if (s.contains(".")) {
            s = s.substring(s.lastIndexOf(46) + 1);
        }
        if (s.contains("$")) {
            s = s.substring(s.lastIndexOf(36) + 1);
        }
        return this.createLabel(s);
    }

    default public String getIconName(String label) {
        if (label == null || label.contains(":")) {
            return null;
        }
        return switch (label.toLowerCase()) {
            case "save", "ok", "yes" -> "check";
            case "cancel", "no", "clear" -> "close";
            default -> label;
        };
    }

    default public ApplicationMenuItem createMenuItem(String menuLabel, String icon, Runnable menuAction) {
        return MenuItem.create(menuLabel, this.getIconName(icon), menuAction);
    }

    default public ApplicationMenuItem createMenuItem(ExecutableView view, String menuLabel, Runnable menuAction) {
        return MenuItem.create(view, menuLabel, menuAction);
    }

    default public ApplicationMenuItemGroup createMenuItemGroup(String menuLabel) {
        return MenuItem.createGroup(menuLabel);
    }

    default public String getActiveMenuIconName() {
        return "vaadin:cogs";
    }

    public static ApplicationEnvironment get() {
        Application a = Application.get();
        return a == null ? null : a.getEnvironment();
    }
}

