/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.helper.ID;
import com.storedobject.helper.LitComponent;
import com.storedobject.vaadin.Alert;
import com.storedobject.vaadin.ApplicationEnvironment;
import com.storedobject.vaadin.ApplicationLayout;
import com.storedobject.vaadin.ApplicationMenu;
import com.storedobject.vaadin.ApplicationMenuItem;
import com.storedobject.vaadin.ApplicationMenuItemGroup;
import com.storedobject.vaadin.ApplicationView;
import com.storedobject.vaadin.HomeView;
import com.storedobject.vaadin.ResizedListener;
import com.storedobject.vaadin.View;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WebBrowser;
import com.vaadin.flow.shared.Registration;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class Application {
    private static final String APP_KEY = "so$app";
    private ApplicationView applicationView;
    private ApplicationLayout applicationLayout;
    private UI ui;
    private ApplicationEnvironment environment;
    private final Map<Object, AlertList> alerts = new HashMap<Object, AlertList>();
    private final Map<Object, Integer> pollIntervals = new HashMap<Object, Integer>();
    private final Map<Class<?>, Object> data = new HashMap();
    private ViewManager viewManager;
    private final ArrayList<WeakReference<Closeable>> resources = new ArrayList();
    private String link;
    private final ArrayList<Command> commands = new ArrayList();
    private transient boolean closing = false;
    String error;
    private boolean speaker = false;
    private Set<SpeakerToggledListener> speakerToggledListeners;
    private ArrayList<WeakReference<ResizedListener>> resizeListeners;
    private WebBrowser webBrowser;
    private final Alert errorText = new Alert(null, NotificationVariant.LUMO_PRIMARY);
    private int deviceWidth = -1;
    private int deviceHeight = -1;

    protected void init(VaadinRequest request) {
        this.webBrowser = VaadinSession.getCurrent().getBrowser();
        String link = request.getContextPath();
        link = link != null && link.length() > 1 && link.startsWith("/") ? link.substring(1) : null;
        this.link = link;
        link = request.getPathInfo();
        if (link != null && !link.equals("/")) {
            this.error = "Unknown application '" + (this.link == null ? "" : this.link) + link + "'.\nPlease use the correct link.";
        } else {
            this.applicationLayout = this.createLayout();
            if (this.applicationLayout == null) {
                this.error = "Layout missing";
            }
        }
        if (this.error == null && !this.init(this.link)) {
            this.error = "Initialization failed";
        }
        if (this.error == null) {
            new Thread(() -> {
                while (!this.closing) {
                    ArrayList<Command> arrayList = this.commands;
                    synchronized (arrayList) {
                        if (!this.commands.isEmpty()) {
                            this.ui.access((Command & Serializable)() -> {
                                this.commands.remove(0);
                                this.ui.push();
                            });
                            if (!this.commands.isEmpty()) {
                                continue;
                            }
                        }
                        try {
                            this.commands.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }).start();
        }
    }

    public String getQueryParameter(String key) {
        return this.applicationView.queryParams == null ? null : this.applicationView.queryParams.get(key);
    }

    public void removeQueryParameter(String key) {
        if (this.applicationView.queryParams != null) {
            this.applicationView.queryParams.remove(key);
            if (this.applicationView.queryParams.isEmpty()) {
                this.applicationView.queryParams = null;
            }
        }
    }

    public void removeQueryParameters() {
        if (this.applicationView.queryParams != null) {
            this.applicationView.queryParams.clear();
            this.applicationView.queryParams = null;
        }
    }

    public WebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    public final Page getPage() {
        return this.ui.getPage();
    }

    public Registration addBrowserResizedListener(ResizedListener listener) {
        if (listener == null) {
            return null;
        }
        if (this.resizeListeners == null) {
            this.resizeListeners = new ArrayList();
        }
        this.resizeListeners.add(new WeakReference<ResizedListener>(listener));
        return (Registration & Serializable)() -> {
            for (WeakReference<ResizedListener> w : this.resizeListeners) {
                if (w.get() != listener) continue;
                this.resizeListeners.remove(w);
                return;
            }
        };
    }

    void fireResized(int width, int height) {
        if (width == this.deviceWidth && height == this.deviceHeight) {
            return;
        }
        this.deviceWidth = width;
        this.deviceHeight = height;
        if (this.resizeListeners != null) {
            this.resizeListeners.removeIf(w -> w.get() == null);
            this.resizeListeners.forEach((Consumer<WeakReference<ResizedListener>>)((Consumer<WeakReference>)w -> {
                ResizedListener l = (ResizedListener)w.get();
                if (l != null) {
                    l.resized(width, height);
                }
            }));
        }
    }

    public Alert getCommonAlert() {
        return this.errorText;
    }

    protected Consumer<UI> getUIConfigurator() {
        return null;
    }

    public final UI getUI() {
        if (this.ui == null) {
            this.setUI(UI.getCurrent());
        }
        return this.ui;
    }

    final void setUI(UI ui) {
        if (ui == null || this.closing) {
            if (ui != null) {
                ui.removeAll();
            }
            return;
        }
        ArrayList<Application> aList = (ArrayList<Application>)VaadinSession.getCurrent().getAttribute(APP_KEY);
        if (aList == null) {
            aList = new ArrayList<Application>();
            VaadinSession.getCurrent().setAttribute(APP_KEY, aList);
        }
        if (!aList.contains(this)) {
            aList.add(this);
        }
        if (this.ui == null) {
            ui.getElement().getStyle().set("--so-header-color", "var(--lumo-primary-contrast-color)").set("--so-header-background", "var(--lumo-primary-color)").set("--so-header-height", "9vh").set("--so-menu-drawer-color", "var(--so-header-color)").set("--so-header-background-50pct", "var(--lumo-primary-color-50pct)").set("--so-hover-background", "var(--lumo-primary-color-50pct)").set("--so-grid-selected-background", "var(--lumo-primary-color-50pct)").set("--so-grid-stripes-background", "var(--lumo-primary-color-10pct)");
        }
        this.ui = ui;
        this.attached();
    }

    public void attached() {
    }

    private void removeUI() {
        this.removeUI(false);
    }

    private void removeUI(boolean removeContent) {
        if (this.ui != null) {
            if (removeContent) {
                try {
                    this.ui.removeAll();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                this.ui.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.ui = null;
        }
    }

    public void detached() {
        this.removeUI();
        new Timer().schedule((TimerTask)new AppCloser(this), 20000L);
    }

    public void setLocale(Locale locale) {
        this.applicationView.setLocale(locale);
    }

    public Locale getLocale() {
        return this.applicationView.locale;
    }

    public Future<Void> access(Command command) {
        UI ui = this.getUI();
        Future result = null;
        try {
            result = ui.access((Command & Serializable)() -> {
                try {
                    command.execute();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (ui.getPushConfiguration().getPushMode().isEnabled()) {
                    try {
                        ui.push();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    protected boolean init(String link) {
        return true;
    }

    protected abstract ApplicationLayout createLayout();

    protected ApplicationEnvironment createEnvironment() {
        return null;
    }

    public final ApplicationEnvironment getEnvironment() {
        if (this.environment == null) {
            this.environment = this.createEnvironment();
        }
        if (this.environment == null) {
            this.environment = new ApplicationEnvironment(this){};
        }
        return this.environment;
    }

    public ApplicationMenuItem createMenuItem(String label, Runnable menuAction) {
        return this.createMenuItem(label, null, menuAction);
    }

    public ApplicationMenuItem createMenuItem(String label, String icon, Runnable menuAction) {
        return this.getEnvironment().createMenuItem(label, icon, menuAction);
    }

    public ApplicationMenuItemGroup createMenuItemGroup(String label) {
        return this.getEnvironment().createMenuItemGroup(label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        ArrayList aList;
        Map<Object, AlertList> map = this.alerts;
        synchronized (map) {
            for (Object owner : this.alerts.keySet()) {
                this.alerts.get(owner).forEach(rec$ -> ((HasComponents)rec$).remove(new Component[0]));
            }
            this.alerts.clear();
        }
        this.closing = true;
        VaadinSession vs = VaadinSession.getCurrent();
        if (vs != null && (aList = (ArrayList)vs.getAttribute(APP_KEY)) != null) {
            aList.remove(this);
        }
        while (this.resources.size() > 0) {
            Closeable resource = (Closeable)this.resources.remove(0).get();
            if (resource == null) continue;
            try {
                resource.close();
            }
            catch (IOException iOException) {}
        }
        if (vs != null) {
            ArrayList<UI> uis = new ArrayList<UI>(vs.getUIs());
            if (this.ui != null) {
                uis.remove(this.ui);
            }
            uis.removeIf(u -> u.isClosing() || Application.get(u) == null);
            if (uis.isEmpty()) {
                this.removeUI(true);
                try {
                    VaadinService.getCurrentRequest().getWrappedSession().invalidate();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    vs.getSession().invalidate();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    vs.close();
                }
                catch (Throwable throwable) {}
            } else {
                this.removeUI(true);
            }
        }
        ArrayList<Command> arrayList = this.commands;
        synchronized (arrayList) {
            this.commands.notifyAll();
        }
    }

    public void registerResource(Closeable resource) {
        this.resources.add(new WeakReference<Closeable>(resource));
    }

    public static Application get() {
        return Application.get(null);
    }

    public static Application get(UI ui) {
        if (ui == null) {
            ui = UI.getCurrent();
        }
        if (ui == null) {
            return null;
        }
        UI u = ui;
        return ((ArrayList)VaadinSession.getCurrent().getAttribute(APP_KEY)).stream().filter(a -> a.ui == u).findAny().orElse(null);
    }

    public static void registerAlert(Alert alert, Object owner) {
        Application a = Application.get();
        if (a == null) {
            return;
        }
        a.regAlert(alert, owner);
    }

    public static List<Alert> getAlerts(Object owner) {
        Application a = Application.get();
        if (a == null) {
            return null;
        }
        return a.alerts.get(owner);
    }

    public static int getAlertCount(Object owner) {
        Application a = Application.get();
        if (a == null) {
            return -1;
        }
        List list = a.alerts.get(owner);
        return list == null ? 0 : list.size();
    }

    public void alertCountChanged(Object owner) {
    }

    public static void showAlerts() {
        Application a = Application.get();
        if (a == null) {
            return;
        }
        for (AlertList alerts : a.alerts.values()) {
            alerts.forEach(Alert::show);
        }
    }

    public static void showAlerts(Object owner) {
        Application a = Application.get();
        if (a == null) {
            return;
        }
        List list = a.alerts.get(owner);
        if (list == null) {
            return;
        }
        list.forEach(Alert::show);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAlerts() {
        Application a = Application.get();
        if (a == null) {
            return;
        }
        Map<Object, AlertList> map = a.alerts;
        synchronized (map) {
            new ArrayList<Object>(a.alerts.keySet()).forEach(a::clrAlerts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAlerts(Object owner) {
        Application a = Application.get();
        if (a == null) {
            return;
        }
        Map<Object, AlertList> map = a.alerts;
        synchronized (map) {
            a.clrAlerts(owner);
        }
    }

    private void clrAlerts(Object owner) {
        List list = this.alerts.get(owner);
        if (list == null) {
            return;
        }
        ArrayList<Alert> listToRemove = new ArrayList<Alert>(list);
        listToRemove.removeIf(a -> !a.deleteOnClose());
        listToRemove.forEach(this::removeAlert);
        if (list.isEmpty()) {
            this.alerts.remove(owner);
        }
    }

    public static void clearAlert(Alert alert) {
        Application a = Application.get();
        if (a == null) {
            return;
        }
        a.removeAlert(alert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeAlert(Alert alert) {
        Map<Object, AlertList> map = this.alerts;
        synchronized (map) {
            for (AlertList list : this.alerts.values()) {
                if (!list.remove(alert) || !list.isEmpty()) continue;
                this.alerts.remove(list.owner);
                break;
            }
        }
        if (alert.isOpened()) {
            alert.close();
        }
    }

    public static void warning(Object message) {
        Application.notification(null, message, 1);
    }

    public static void tray(Object message) {
        Application.notification(null, null, message, 1, Notification.Position.BOTTOM_END, false);
    }

    public static void message(Object message) {
        if (message instanceof Throwable) {
            Application.error(message);
        } else {
            Application.notification(null, message, 0);
        }
    }

    public static void error(Object message) {
        Application.notification(null, message, 2);
    }

    public static void warning(Object owner, Object message) {
        Application.notification(owner, message, 1);
    }

    public static void tray(Object owner, Object message) {
        Application.notification(null, owner, message, 1, Notification.Position.BOTTOM_END, false);
    }

    public static void message(Object owner, Object message) {
        if (message instanceof Throwable) {
            Application.error(owner, message);
        } else {
            Application.notification(owner, message, 0);
        }
    }

    public static void error(Object owner, Object message) {
        Application.notification(owner, message, 2);
    }

    private static void notification(Object owner, Object message, int messageType) {
        Application.notification(null, owner, message, messageType, null, true);
    }

    static void notification(Application a, Object owner, Object message, int messageType, Notification.Position position) {
        Application.notification(a, owner, message, messageType, position, messageType == 2);
    }

    private static void notification(Application a, Object owner, Object message, int messageType, Notification.Position position, boolean log) {
        if (a == null) {
            a = Application.get();
        }
        if (message instanceof Notification) {
            if (a != null) {
                a.access(() -> ((Notification)((Notification)message)).open());
            } else {
                ((Notification)message).open();
            }
            return;
        }
        String m = null;
        if (log && (a == null || messageType == 2)) {
            if (message instanceof Throwable) {
                if (a == null) {
                    ((Throwable)message).printStackTrace();
                } else {
                    a.log(message);
                }
            } else if (a != null) {
                m = a.getEnvironment().toDisplay(message);
                a.log(a.getEnvironment().toString(m));
            }
        }
        if (m == null) {
            m = a == null ? message.toString() : a.getEnvironment().toDisplay(message);
        }
        Alert n = new Alert(m.replace("\n", "<BR>"));
        if (position != null) {
            n.setPosition(position);
        }
        switch (messageType) {
            case 1: {
                messageType = 20000;
                n.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_CONTRAST});
                break;
            }
            case 2: {
                messageType = Integer.MAX_VALUE;
                n.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_ERROR});
                break;
            }
            default: {
                messageType = 10000;
                n.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
            }
        }
        n.setDuration(messageType);
        if (a == null) {
            System.err.println(m);
            n.open();
        } else {
            a.access(() -> ((Alert)n).open());
            a.regAlert(n, owner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void regAlert(Alert alert, Object owner) {
        alert.addOpenedChangeListener((ComponentEventListener & Serializable)e -> {
            if (!alert.isOpened() && alert.deleteOnClose()) {
                this.removeAlert(alert);
            }
        });
        if (owner != null) {
            Map<Object, AlertList> map = this.alerts;
            synchronized (map) {
                this.alerts.computeIfAbsent(owner, k -> new AlertList(owner)).add(alert);
            }
        }
    }

    public void log(Object anything) {
        if (anything instanceof Throwable) {
            ((Throwable)anything).printStackTrace();
        } else {
            System.err.println(anything);
        }
    }

    public void log(Object anything, Throwable error) {
        if (anything instanceof Throwable) {
            ((Throwable)anything).printStackTrace();
        } else {
            System.err.println(anything);
        }
        if (error != null) {
            error.printStackTrace();
        }
    }

    public String getLinkName() {
        return this.link;
    }

    public int getDeviceHeight() {
        if (this.deviceHeight > 0) {
            return this.deviceHeight;
        }
        this.getDeviceWidth();
        return this.deviceHeight;
    }

    public int getDeviceWidth() {
        if (this.deviceWidth > 0) {
            return this.deviceWidth;
        }
        if (this.viewManager != null) {
            this.viewManager.content.checkSize();
        }
        return this.deviceWidth;
    }

    public String getURL() {
        return this.applicationView == null ? null : this.applicationView.getURL();
    }

    public int getContentHeight() {
        return this.viewManager.content.h();
    }

    public int getContentWidth() {
        return this.viewManager.content.w();
    }

    public Registration addContentResizedListener(ResizedListener listener) {
        return this.viewManager.content.addContentResizedListener(listener);
    }

    public void showNotification(String text) {
        this.showNotification(null, text);
    }

    public void showNotification(String caption, String text) {
        Application.notification(this, caption, text, 2, Notification.Position.BOTTOM_END, false);
    }

    public void showNotification(Throwable error) {
        this.showNotification(null, error);
    }

    public void showNotification(String caption, Throwable error) {
        Object e = this.getEnvironment().toDisplay(error);
        if (!((String)e).toLowerCase().contains("error")) {
            e = "Error: " + (String)e;
        }
        Application.notification(this, caption, e, 2, Notification.Position.BOTTOM_END, false);
    }

    final void setMainView(ApplicationView applicationView) {
        this.applicationView = applicationView;
        if (this.viewManager == null) {
            this.viewManager = new ViewManager(this);
            this.applicationLayout.closeMenu();
            this.login();
        }
    }

    public void setCaption(String caption) {
        if (this.applicationLayout != null) {
            this.applicationLayout.setCaption(caption);
        }
        this.getPage().setTitle(caption);
    }

    public void speak(String sentence) {
        if (sentence != null && this.speaker && this.viewManager != null) {
            if ((sentence = sentence.trim()).isEmpty()) {
                return;
            }
            sentence = sentence.replaceAll("\\s+", " ");
            while (sentence.contains("  ")) {
                sentence = sentence.replace("  ", " ");
            }
            this.viewManager.content.speak(sentence);
        }
    }

    public boolean isSpeaking() {
        return this.speaker && this.viewManager != null && this.viewManager.content.speaking;
    }

    synchronized void setSpeaker(boolean on) {
        this.speaker = on;
        if (this.speakerToggledListeners != null) {
            this.speakerToggledListeners.forEach(listener -> listener.speaker(this.speaker));
        }
    }

    public boolean isSpeakerOn() {
        return this.speaker;
    }

    Registration addSpeakerToggedListener(SpeakerToggledListener listener) {
        if (listener == null) {
            return null;
        }
        if (this.speakerToggledListeners == null) {
            this.speakerToggledListeners = new HashSet<SpeakerToggledListener>();
        }
        this.speakerToggledListeners.add(listener);
        return (Registration & Serializable)() -> this.speakerToggledListeners.remove(listener);
    }

    protected void login() {
        this.loggedin();
    }

    public String getIPAddress() {
        return this.webBrowser.getAddress();
    }

    public String getIdentifier() {
        return this.webBrowser.getBrowserApplication();
    }

    public int getMajorVersion() {
        return this.webBrowser.getBrowserMajorVersion();
    }

    public int getMinorVersion() {
        return this.webBrowser.getBrowserMinorVersion();
    }

    void execute(View view, boolean doNotLock, View parent) {
        this.viewManager.attach(view, doNotLock, parent);
    }

    void close(View view) {
        this.viewManager.detach(view);
        this.viewDetached(view);
    }

    boolean select(View view) {
        return this.viewManager.select(view);
    }

    protected final void loggedin() {
        this.viewManager.loggedIn(this);
        this.applicationLayout.toggleMenu();
        Component menuSearcher = this.applicationLayout.getMenuSearcher();
        if (menuSearcher instanceof Focusable) {
            ((Focusable)menuSearcher).focus();
        }
        this.getContentWidth();
    }

    public void setPostFocus(Component component) {
        View v = this.viewManager.getActiveView();
        if (v != null) {
            v.setPostFocus(component);
        }
    }

    public View getActiveView() {
        return this.viewManager.getActiveView();
    }

    public void setPollInterval(int intervalInMillis) {
        this.setPollInterval(this, intervalInMillis);
    }

    public void setPollInterval(Object owner, int intervalInMillis) {
        Integer pi;
        if (owner == null) {
            return;
        }
        if (intervalInMillis <= 0) {
            intervalInMillis = -1;
        }
        if ((pi = this.pollIntervals.get(owner)) == null) {
            if (intervalInMillis == -1) {
                return;
            }
            this.pollIntervals.put(owner, intervalInMillis);
            this.setPoll();
            return;
        }
        if (pi == intervalInMillis) {
            return;
        }
        if (intervalInMillis == -1) {
            this.pollIntervals.remove(owner);
            this.setPoll();
            return;
        }
        this.pollIntervals.put(owner, intervalInMillis);
        if (intervalInMillis < pi) {
            if (intervalInMillis <= this.ui.getPollInterval()) {
                this.ui.setPollInterval(intervalInMillis);
            }
            return;
        }
        this.setPoll();
    }

    private void setPoll() {
        int pi = this.pollIntervals.values().stream().min(Comparator.comparing(Integer::valueOf)).orElse(-1);
        UI u = this.ui;
        if (u != null) {
            u.access((Command & Serializable)() -> {
                if (this.ui != null) {
                    u.setPollInterval(pi);
                }
            });
        }
    }

    public void startPolling(Object owner) {
        this.setPollInterval(owner, 1000);
    }

    public void stopPolling(Object owner) {
        this.setPollInterval(owner, -1);
    }

    public View getViewFor(Component component) {
        return this.viewManager == null ? null : this.viewManager.getViewFor(component);
    }

    protected void viewDetached(View view) {
    }

    public int getActiveViewCount() {
        return (int)this.viewManager.contentMenu.keySet().stream().filter(v -> !v.isHomeView()).count();
    }

    public Stream<View> getActiveViews() {
        return this.viewManager.contentMenu.keySet().stream().filter(v -> !v.isHomeView());
    }

    public void execute(Runnable command, boolean clearViews) {
        UI ui;
        if (this.viewManager != null && (ui = this.getUI()) != null && UI.getCurrent() == ui) {
            this.viewManager.execute(command, clearViews);
        }
    }

    public void execute(Runnable command) {
        UI ui;
        if (this.viewManager != null && (ui = this.getUI()) != null && UI.getCurrent() == ui) {
            command.run();
        }
    }

    public void setData(Object anything) {
        if (anything != null) {
            this.data.put(anything.getClass(), anything);
        }
    }

    public <T> void setData(Class<T> anyClass, T anything) {
        if (anything != null) {
            this.data.put(anyClass, anything);
        }
    }

    public <T> void removeData(T anything) {
        if (anything != null) {
            this.removeData(anything.getClass());
        }
    }

    public <T> void removeData(Class<T> anyClass) {
        if (anyClass != null) {
            this.data.remove(anyClass);
        }
    }

    public <T> T getData(Class<T> anyClass) {
        return (T)(anyClass == null ? null : this.data.get(anyClass));
    }

    public String getCountry() {
        return "US";
    }

    public String getCaption() {
        return this.applicationLayout == null ? null : this.applicationLayout.getCaption();
    }

    public boolean isFullScreenMode() {
        return this.viewManager.isFS();
    }

    boolean executing(View view) {
        return this.viewManager.executing(view);
    }

    private static class AppCloser
    extends TimerTask {
        private final Application a;

        private AppCloser(Application a) {
            this.a = a;
        }

        @Override
        public void run() {
            if (this.a.ui == null) {
                this.a.close();
            }
        }
    }

    private class AlertList
    extends ArrayList<Alert> {
        private final Object owner;

        private AlertList(Object owner) {
            this.owner = owner;
        }

        @Override
        public Alert remove(int index) {
            Alert a = (Alert)super.remove(index);
            if (a != null) {
                Application.this.alertCountChanged(this.owner);
            }
            return a;
        }

        @Override
        public boolean remove(Object o) {
            if (super.remove(o)) {
                Application.this.alertCountChanged(this.owner);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (super.removeAll(c)) {
                Application.this.alertCountChanged(this.owner);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeIf(Predicate<? super Alert> filter) {
            if (super.removeIf(filter)) {
                Application.this.alertCountChanged(this.owner);
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            if (super.retainAll(c)) {
                Application.this.alertCountChanged(this.owner);
                return true;
            }
            return false;
        }

        @Override
        public boolean add(Alert alert) {
            super.add(alert);
            Application.this.alertCountChanged(this.owner);
            return true;
        }

        @Override
        public void add(int index, Alert element) {
            super.add(index, element);
            Application.this.alertCountChanged(this.owner);
        }

        @Override
        public boolean addAll(Collection<? extends Alert> c) {
            super.addAll(c);
            Application.this.alertCountChanged(this.owner);
            return true;
        }

        @Override
        public boolean addAll(int index, Collection<? extends Alert> c) {
            super.addAll(index, c);
            Application.this.alertCountChanged(this.owner);
            return true;
        }
    }

    private static class ViewManager {
        private final ApplicationMenu menu;
        private final ApplicationView applicationView;
        private final List<View> stack = new ArrayList<View>();
        private final List<View> homeStack = new ArrayList<View>();
        private final Map<View, ApplicationMenuItem> contentMenu = new HashMap<View, ApplicationMenuItem>();
        private final Map<View, View> parents = new HashMap<View, View>();
        private View homeView;
        private Runnable pendingToRun;
        private final Content content;

        public ViewManager(Application application) {
            this.applicationView = application.applicationView;
            this.menu = this.applicationView.layout.getMenu();
            this.content = new Content(application);
            this.applicationView.layout.setContent((Component)this.content);
        }

        public void loggedIn(Application application) {
            this.applicationView.layout.loggedin(application);
            this.applicationView.layout.drawMenu(application);
        }

        private void runPending() {
            if (this.pendingToRun != null) {
                Runnable r = this.pendingToRun;
                this.pendingToRun = null;
                r.run();
            }
        }

        public void execute(Runnable runnable, boolean clearViews) {
            if (runnable == null) {
                runnable = () -> {};
            }
            if (this.pendingToRun != null) {
                this.pendingToRun = runnable;
                return;
            }
            if (!clearViews || this.clearViewStack(runnable)) {
                runnable.run();
            }
        }

        private boolean clearViewStack(Runnable pending) {
            View view = this.contentMenu.keySet().stream().filter(v -> !v.isHomeView()).findAny().orElse(null);
            if (view == null) {
                return true;
            }
            this.pendingToRun = pending;
            view.abort();
            return false;
        }

        private View getViewFor(Component c) {
            for (View v : this.stack) {
                if (!ViewManager.isViewFor(c, v)) continue;
                return v;
            }
            return null;
        }

        private static boolean isViewFor(Component c, View v) {
            if (c == null) {
                return false;
            }
            if (v.getComponent() == c) {
                return true;
            }
            return ViewManager.isViewFor(c.getParent().orElse(null), v);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attach(View view, boolean doNotLock, View parent) {
            List<View> list = this.stack;
            synchronized (list) {
                this.attachInt(view, doNotLock, parent);
            }
        }

        private void attachInt(View view, boolean doNotLock, View parent) {
            if (this.select(view)) {
                return;
            }
            View current = this.getActiveView();
            Component c = view.getComponent();
            boolean window = c instanceof Dialog;
            if (view.isHomeView() && this.homeView != null && !window) {
                this.homeStack.add(this.homeView);
                this.homeView.setVisibility(false);
                this.homeView = null;
            }
            if (window && parent == null && this.stack.size() > 0 && (parent = this.stack.get(this.stack.size() - 1)).getComponent() instanceof Dialog) {
                parent = null;
            }
            if (parent != null) {
                if (!doNotLock) {
                    if (this.abortChild(parent, false) && this.abortChild(parent, false)) {
                        Application.warning("Unable to run: " + view.getCaption());
                        return;
                    }
                    ApplicationMenuItem m = this.contentMenu.get(parent);
                    if (m != null) {
                        m.setEnabled(false);
                    }
                }
                this.parents.put(view, parent);
            }
            if (!window) {
                this.hideAllContent(null);
            }
            this.stack.add(view);
            view.decorateComponent();
            boolean fs = c instanceof Dialog && this.isFS() ? true : this.isFS(view, parent);
            this.applicationView.setLayoutVisible(!fs);
            if (c instanceof Dialog) {
                UI.getCurrent().add(new Component[]{c});
            } else if (fs) {
                this.applicationView.add(c);
            } else {
                this.content.getElement().appendChild(new Element[]{c.getElement()});
            }
            view.setVisibility(true);
            ApplicationMenuItem m = view.getMenuItem(() -> this.select(view));
            if (view.isHomeView()) {
                if (!(view.getComponent() instanceof Dialog)) {
                    this.homeView = view;
                }
            } else {
                this.menu.insert(0, m);
            }
            this.contentMenu.put(view, m);
            if (current != null && current.getComponent() instanceof Dialog && !window) {
                this.select(current);
                return;
            }
            this.hilite(m);
            this.applicationView.layout.viewSelected(view);
        }

        private boolean abortChild(View view, boolean suicide) {
            View child = this.child(view);
            if (child != null && this.executing(child)) {
                if (suicide) {
                    child.detachParentOnClose();
                }
                this.select(child);
                child.abort();
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void detach(View view) {
            List<View> list = this.stack;
            synchronized (list) {
                this.detachInt(view);
            }
        }

        private void detachInt(View view) {
            if (this.abortChild(view, true)) {
                return;
            }
            ApplicationMenuItem m = this.contentMenu.get(view);
            if (m == null) {
                this.runPending();
                return;
            }
            if (!view.isHomeView()) {
                this.menu.remove(m);
            }
            if (view == this.homeView && !(view.getComponent() instanceof Dialog)) {
                this.homeView = null;
            }
            this.contentMenu.remove(view);
            view.getComponent().getElement().removeFromParent();
            this.applicationView.setLayoutVisible(true);
            this.stack.remove(view);
            this.homeStack.remove(view);
            View parent = this.parents.remove(view);
            if (parent != null) {
                if (this.pendingToRun != null) {
                    parent.abort();
                    return;
                }
                m = this.contentMenu.get(parent);
                if (m != null) {
                    m.setEnabled(true);
                }
                boolean selected = this.select(parent);
                parent.returnedFrom(view);
                if (!selected && (parent = this.getActiveView()) != null) {
                    this.select(parent);
                }
            } else if (this.stack.isEmpty()) {
                if (this.homeView == null && !this.homeStack.isEmpty()) {
                    this.homeView = this.homeStack.remove(this.homeStack.size() - 1);
                    this.homeView.setVisibility(true);
                }
                this.runPending();
            } else {
                view = this.stack.get(this.stack.size() - 1);
                if (this.pendingToRun != null) {
                    if (view instanceof HomeView) {
                        this.runPending();
                        return;
                    }
                    view.abort();
                    return;
                }
                this.select(view);
            }
        }

        public View getActiveView() {
            return this.stack.size() > 0 ? this.stack.get(this.stack.size() - 1) : null;
        }

        private View child(View view) {
            return this.parents.keySet().stream().filter(k -> this.parents.get(k) == view).findAny().orElse(null);
        }

        private boolean isFS(View view, View parent) {
            return view.isFullScreen() || this.isFS(parent);
        }

        private boolean isFS(View view) {
            if (view == null) {
                return false;
            }
            if (view.isFullScreen()) {
                return true;
            }
            return this.isFS(this.parents.get(view));
        }

        private boolean isFS() {
            return !this.applicationView.layout.getComponent().isVisible();
        }

        private void hideAllContent(View except) {
            this.stack.forEach(v -> v.setVisibility(v == except));
            if (except != null) {
                this.applicationView.setLayoutVisible(!this.isFS(except));
            }
        }

        private boolean select(View view) {
            ApplicationMenuItem m = this.contentMenu.get(view);
            if (m == null) {
                return false;
            }
            if (!m.isEnabled()) {
                return true;
            }
            View current = this.getActiveView();
            if (view == current) {
                current = null;
            }
            if (current != null && current.getComponent() instanceof Dialog && !(view.getComponent() instanceof Dialog)) {
                return true;
            }
            this.hideAllContent(view);
            this.hilite(m);
            this.stack.remove(view);
            this.stack.add(view);
            this.applicationView.layout.viewSelected(view);
            return true;
        }

        private boolean executing(View view) {
            return this.contentMenu.get(view) != null;
        }

        private void hilite(ApplicationMenuItem menuItem) {
            menuItem.setEnabled(true);
            this.contentMenu.values().forEach(mi -> {
                if (mi == menuItem) {
                    mi.hilite();
                } else {
                    mi.dehilite();
                }
            });
        }

        @Tag(value="so-app-content")
        @JsModule(value="./so/appcontent/content.js")
        private static class Content
        extends LitComponent {
            private final ArrayList<WeakReference<ResizedListener>> resizeListeners = new ArrayList();
            private int width = -1;
            private int height = -1;
            private boolean speaking = false;
            private StringBuilder sentence;
            private final Application application;

            public Content(Application application) {
                this.application = application;
                this.getElement().setProperty("idContent", "so" + ID.newID());
                application.applicationLayout.resizeContent();
            }

            @ClientCallable
            private void resized(int w, int h, int ww, int wh) {
                if (w != this.width || h != this.height) {
                    this.width = w;
                    this.height = h;
                    this.resizeListeners.removeIf(wr -> wr.get() == null);
                    this.resizeListeners.forEach((Consumer<WeakReference<ResizedListener>>)((Consumer<WeakReference>)wr -> {
                        ResizedListener l = (ResizedListener)wr.get();
                        if (l != null) {
                            l.resized(this.width, this.height);
                        }
                    }));
                }
                this.application.fireResized(ww, wh);
            }

            int w() {
                if (this.width > 0) {
                    return this.width;
                }
                this.checkSize();
                return this.width;
            }

            int h() {
                if (this.height > 0) {
                    return this.height;
                }
                this.w();
                return this.height;
            }

            private void checkSize() {
                this.executeJS("sendSize", new Serializable[0]);
            }

            Registration addContentResizedListener(ResizedListener listener) {
                this.resizeListeners.add(new WeakReference<ResizedListener>(listener));
                if (this.height > -1) {
                    listener.resized(this.width, this.height);
                }
                return (Registration & Serializable)() -> {
                    for (WeakReference<ResizedListener> w : this.resizeListeners) {
                        if (w.get() != listener) continue;
                        this.resizeListeners.remove(w);
                        return;
                    }
                };
            }

            synchronized void speak(String sentence) {
                if (this.speaking) {
                    if (this.sentence == null) {
                        this.sentence = new StringBuilder(sentence);
                    } else {
                        this.sentence.append(' ').append(sentence);
                    }
                    return;
                }
                if (this.sentence != null) {
                    this.sentence.append(' ').append(sentence);
                }
                this.toSpeak(this.sentence == null ? sentence : this.sentence.toString());
            }

            @ClientCallable
            private synchronized void spoken() {
                if (this.sentence != null) {
                    this.toSpeak(this.sentence.toString());
                    return;
                }
                this.speaking = false;
            }

            private void toSpeak(String sentence) {
                this.speaking = true;
                this.getElement().setProperty("speak", sentence);
                this.sentence = null;
            }
        }
    }

    static interface SpeakerToggledListener {
        public void speaker(boolean var1);
    }
}

