/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.Application;
import com.storedobject.vaadin.StyledText;
import com.storedobject.vaadin.util.ClickNotifier;
import com.storedobject.vaadin.util.ElementClick;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.function.Consumer;

public class Alert
extends Notification
implements HasText,
ClickNotifier {
    private static Notification.Position DEFAULT_POSITION = Notification.Position.BOTTOM_START;
    private final StyledText content;
    private final ElementClick click;
    private final Consumer<Alert> clickAction;

    public Alert(String htmlText) {
        this(null, htmlText, null, null);
    }

    public Alert(String htmlText, Consumer<Alert> clickAction) {
        this(null, htmlText, clickAction);
    }

    public Alert(String caption, String htmlText) {
        this(caption, htmlText, null, null);
    }

    public Alert(String caption, String htmlText, Consumer<Alert> clickAction) {
        this(Alert.styled(caption, htmlText), clickAction);
    }

    public Alert(String htmlText, NotificationVariant style) {
        this(null, htmlText, null, style);
    }

    public Alert(String htmlText, Consumer<Alert> clickAction, NotificationVariant style) {
        this(null, htmlText, clickAction, style);
    }

    public Alert(String caption, String htmlText, NotificationVariant style) {
        this(caption, htmlText, null, style);
    }

    public Alert(String caption, String htmlText, Consumer<Alert> clickAction, NotificationVariant style) {
        this(Alert.styled(caption, htmlText), clickAction, style);
    }

    protected Alert(StyledText htmlContent, Consumer<Alert> clickAction) {
        this(htmlContent, clickAction, null);
    }

    protected Alert(StyledText htmlContent, Consumer<Alert> clickAction, NotificationVariant style) {
        this.clickAction = clickAction;
        this.content = htmlContent;
        this.content.getElement().getStyle().set("cursor", "pointer");
        this.add(new Component[]{this.content});
        this.click = new ElementClick((Component)this.content);
        this.addClickListener((ComponentEventListener<ClickEvent<Component>>)(ComponentEventListener & Serializable)e -> this.clicked());
        if (style != null) {
            this.addThemeVariants((ThemeVariant[])new NotificationVariant[]{style});
        }
        this.setPosition(DEFAULT_POSITION);
    }

    private static StyledText styled(String caption, String text) {
        text = new StyledText(text).getText();
        if (caption == null || caption.isEmpty()) {
            return new StyledText(text);
        }
        return new StyledText("<span>" + caption + "</span><br/>" + text);
    }

    public Registration addClickListener(ComponentEventListener<ClickEvent<Component>> listener) {
        return this.click.addClickListener(listener);
    }

    @Override
    public void removeClickListener(ComponentEventListener<ClickEvent<Component>> listener) {
        this.click.removeClickListener(listener);
    }

    @Override
    public Registration replaceClickListener(ComponentEventListener<ClickEvent<Component>> oldListener, ComponentEventListener<ClickEvent<Component>> newListener) {
        return this.click.replaceClickListener(oldListener, newListener);
    }

    public void show() {
        this.open();
    }

    public void clicked() {
        if (this.clickAction == null) {
            this.close();
        } else {
            this.clickAction.accept(this);
        }
    }

    public void setText(String text) {
        this.content.setText(text);
        if (text != null && !text.isEmpty()) {
            this.open();
        } else {
            this.close();
        }
    }

    public String getText() {
        return this.content.getText();
    }

    public StyledText getContent() {
        return this.content;
    }

    public Consumer<Alert> getClickAction() {
        return this.clickAction;
    }

    public void delete() {
        Application.get().removeAlert(this);
    }

    public boolean deleteOnClose() {
        return this.clickAction == null;
    }

    public static void setDefaultPosition(Notification.Position defaultPosition) {
        DEFAULT_POSITION = defaultPosition;
    }
}

