/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.TextField;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.data.value.ValueChangeMode;
import java.io.Serializable;
import java.util.function.Consumer;

public class ActionTextField
extends TextField {
    private Consumer<String> action;
    private boolean ignoreProgrammaticChanges = false;
    private String actionText = null;
    private int transform = 0;

    public ActionTextField(Consumer<String> action) {
        this.init(action);
    }

    public ActionTextField(String label, Consumer<String> action) {
        super(label);
        this.init(action);
    }

    public ActionTextField(String label, String placeholder, Consumer<String> action) {
        super(label, placeholder);
        this.init(action);
    }

    public ActionTextField(String label, String initialValue, String placeholder, Consumer<String> action) {
        super(label, initialValue, placeholder);
        this.init(action);
    }

    private void init(Consumer<String> action) {
        this.action = action;
        this.addKeyPressListener(Key.ENTER, (ComponentEventListener & Serializable)e -> this.act(), new KeyModifier[0]);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (this.ignoreProgrammaticChanges && !e.isFromClient()) {
                return;
            }
            this.act();
        });
        this.setValueChangeMode(ValueChangeMode.TIMEOUT);
        this.setValueChangeTimeout(1000);
    }

    public void setIgnoreProgrammaticChanges(boolean ignore) {
        this.ignoreProgrammaticChanges = ignore;
    }

    public void setAction(Consumer<String> action) {
        this.action = action;
    }

    public Consumer<String> getAction() {
        return this.action;
    }

    synchronized void act() {
        this.act(this.getValue());
    }

    public synchronized void act(String actionText) {
        if (actionText == null) {
            return;
        }
        actionText = this.getActionText(actionText);
        if (this.actionText != null && this.actionText.equals(actionText)) {
            this.focus();
            return;
        }
        this.actionText = actionText;
        Consumer<String> a = this.getAction();
        if (a != null) {
            a.accept(actionText);
        }
        this.focus();
    }

    public String getActionText() {
        return this.getActionText(this.getValue());
    }

    private String getActionText(String t) {
        if (t == null) {
            return null;
        }
        if ((this.transform & 1) == 1) {
            t = t.trim();
        }
        if ((this.transform & 2) == 2) {
            t = t.toUpperCase();
        } else if ((this.transform & 4) == 4) {
            t = t.toLowerCase();
        }
        return t;
    }

    public String getPreviousActionText() {
        return this.actionText;
    }

    public ActionTextField trim() {
        this.transform |= 1;
        return this;
    }

    public ActionTextField toUpperCase() {
        this.transform |= 2;
        this.transform &= 0xFFFFFFFB;
        return this;
    }

    public ActionTextField toLowerCase() {
        this.transform |= 4;
        this.transform &= 0xFFFFFFFD;
        return this;
    }
}

