/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.DataForm;
import com.storedobject.vaadin.View;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.dom.Style;
import java.util.function.BooleanSupplier;

public class ActionForm
extends DataForm {
    private Runnable actionYes;
    private Runnable actionNo;
    private BooleanSupplier preconfirm;

    public ActionForm(String message) {
        this(null, message, null, null, null, null);
    }

    public ActionForm(String message, Runnable action) {
        this(null, message, action, null, null, null);
    }

    public ActionForm(Component message, Runnable action) {
        this(null, message, action, null, null, null);
    }

    public ActionForm(String message, Runnable action, String labelYes, String labelNo) {
        this(null, message, action, null, labelYes, labelNo);
    }

    public ActionForm(Component message, Runnable action, String labelYes, String labelNo) {
        this(null, message, action, null, labelYes, labelNo);
    }

    public ActionForm(String message, Runnable actionYes, Runnable actionNo) {
        this(null, message, actionYes, actionNo, null, null);
    }

    public ActionForm(Component message, Runnable actionYes, Runnable actionNo) {
        this(null, message, actionYes, actionNo, null, null);
    }

    public ActionForm(String message, Runnable actionYes, Runnable actionNo, String labelYes, String labelNo) {
        this(null, ActionForm.createLabel(message), actionYes, actionNo, labelYes, labelNo);
    }

    public ActionForm(Component message, Runnable actionYes, Runnable actionNo, String labelYes, String labelNo) {
        this(null, message, actionYes, actionNo, labelYes, labelNo);
    }

    public ActionForm(String caption, String message, Runnable action) {
        this(caption, message, action, null, null, null);
    }

    public ActionForm(String caption, Component message, Runnable action) {
        this(caption, message, action, null, null, null);
    }

    public ActionForm(String caption, String message, Runnable action, String labelYes, String labelNo) {
        this(caption, message, action, null, labelYes, labelNo);
    }

    public ActionForm(String caption, Component message, Runnable action, String labelYes, String labelNo) {
        this(caption, message, action, null, labelYes, labelNo);
    }

    public ActionForm(String caption, String message, Runnable actionYes, Runnable actionNo) {
        this(caption, message, actionYes, actionNo, null, null);
    }

    public ActionForm(String caption, Component message, Runnable actionYes, Runnable actionNo) {
        this(caption, message, actionYes, actionNo, null, null);
    }

    public ActionForm(String caption, String message, Runnable actionYes, Runnable actionNo, String labelYes, String labelNo) {
        this(caption, ActionForm.createLabel(message), actionYes, actionNo, labelYes, labelNo);
    }

    public ActionForm(String caption, Component message, Runnable actionYes, Runnable actionNo, String labelYes, String labelNo) {
        super("");
        this.setCaption(caption == null || caption.isEmpty() ? this.getDefaultCaption() : caption);
        this.ok.setText(labelYes == null || labelYes.isEmpty() ? this.getDefaultYesLabel() : labelYes);
        this.cancel.setText(labelNo == null || labelNo.isEmpty() ? this.getDefaultNoLabel() : labelNo);
        this.setConfirmAction(actionYes);
        this.setCancelAction(actionNo);
        this.add(message);
    }

    protected String getDefaultYesLabel() {
        return "Yes";
    }

    protected String getDefaultNoLabel() {
        return "No";
    }

    protected String getDefaultCaption() {
        return "Confirm";
    }

    private static Component createLabel(String message) {
        Span s;
        if (message == null || !message.contains("\n")) {
            s = new Span(message);
            ActionForm.hilite(s.getStyle());
        } else {
            s = new Span();
            message.lines().forEach(m -> {
                Div div = new Div();
                div.setText(m);
                ActionForm.hilite(div.getStyle());
                s.add(new Component[]{div});
            });
        }
        return s;
    }

    private static void hilite(Style style) {
        style.set("font-size", "15px");
        style.set("font-weight", "BOLD");
        style.set("color", "red");
    }

    @Override
    protected HasComponents createFieldContainer() {
        return new Div();
    }

    @Override
    protected void buildFields() {
    }

    public Runnable getConfirmAction() {
        return this.actionYes;
    }

    public void setConfirmAction(Runnable actionYes) {
        this.actionYes = actionYes;
    }

    public Runnable getCancelAction() {
        return this.actionNo;
    }

    public void setCancelAction(Runnable actionNo) {
        this.actionNo = actionNo;
    }

    @Override
    protected final void cancel() {
        super.cancel();
        if (this.actionNo != null) {
            this.actionNo.run();
        }
    }

    @Override
    protected final boolean process() {
        this.close();
        if (this.actionYes != null) {
            this.actionYes.run();
        }
        return true;
    }

    public void setPreconfirm(BooleanSupplier preconfirm) {
        this.preconfirm = preconfirm;
    }

    @Override
    protected void execute(View parent, boolean doNotLock) {
        if (this.preconfirm != null && !this.preconfirm.getAsBoolean()) {
            return;
        }
        super.execute(parent, doNotLock);
        this.getContent().getElement().getStyle().set("min-height", "10px");
    }

    public static void execute(String message, Runnable action) {
        new ActionForm(message, action).execute();
    }

    public static void execute(Component message, Runnable action) {
        new ActionForm(message, action).execute();
    }
}

