/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.helper.ID;
import com.storedobject.vaadin.HasSize;
import com.storedobject.vaadin.ResourceSupport;
import com.storedobject.vaadin.ResourcedComponent;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.server.AbstractStreamResource;

public abstract class AbstractResourcedComponent
extends Component
implements ResourcedComponent,
HasSize {
    private final ResourceSupport resourceSupport;

    public AbstractResourcedComponent() {
        this((String)null);
    }

    public AbstractResourcedComponent(String fileURI) {
        this.init();
        this.resourceSupport = new ResourceSupport(this);
        if (fileURI != null) {
            this.setURI(fileURI);
        }
    }

    public AbstractResourcedComponent(AbstractStreamResource streamResource) {
        this.init();
        this.resourceSupport = new ResourceSupport(this);
        if (streamResource != null) {
            this.setSource(streamResource);
        }
    }

    protected void init() {
        ID.set((Component)this);
        this.getElement().getStyle().set("display", "flex");
        this.setSizeFull();
    }

    public void setSource(String fileURL) {
        this.resourceSupport.clear();
        this.setURI(fileURL);
    }

    protected abstract String getURIAttributeName();

    protected void setURI(String url) {
        if (url == null) {
            this.getElement().removeAttribute(this.getURIAttributeName());
            this.clear();
        } else {
            this.getElement().setAttribute(this.getURIAttributeName(), url);
        }
    }

    @Override
    public void setSource(AbstractStreamResource streamResource) {
        this.resourceSupport.register(streamResource);
        String uri = this.resourceSupport.getURI();
        if (uri != null) {
            this.setURI(uri);
        }
    }

    public void clear() {
        this.resourceSupport.clear();
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.resourceSupport.register();
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.resourceSupport.unregister();
    }
}

