/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.AbstractDataForm;
import com.storedobject.vaadin.ApplicationEnvironment;
import com.storedobject.vaadin.FormLayout;
import com.storedobject.vaadin.IncludeField;
import com.storedobject.vaadin.View;
import com.storedobject.vaadin.ViewDependent;
import com.storedobject.vaadin.util.Data;
import com.storedobject.vaadin.util.FieldValueHandler;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class AbstractForm<D>
extends Composite<Component> {
    protected final Class<D> objectClass;
    protected D objectData;
    protected HasComponents container;
    protected final Data<D> data;
    private boolean loadPending = false;
    private View view;
    private int columns = 2;
    IncludeField includeField = new IncludeFieldArray();

    public AbstractForm(Class<D> objectClass) {
        this(objectClass, null);
    }

    public AbstractForm(Class<D> objectClass, HasComponents container) {
        this(objectClass, container, null);
        this.data.setFieldValueHandler(new ValueHandler());
    }

    protected AbstractForm(Class<D> objectClass, HasComponents container, Object dummy) {
        this.objectClass = objectClass;
        this.data = new Data(this);
        this.container = container;
    }

    protected final Component initContent() {
        return (Component)this.container;
    }

    public final Component getContent() {
        return (Component)this.getContainer();
    }

    public Binder<D> getBinder() {
        return this.data.getBinder();
    }

    public void setIncludeFieldChecker(IncludeField includeField) {
        ((IncludeFieldArray)this.includeField).clear();
        if (includeField != null) {
            ((IncludeFieldArray)this.includeField).add(includeField);
        }
    }

    public Registration addIncludeFieldChecker(IncludeField includeField) {
        if (includeField == null) {
            return (Registration & Serializable)() -> {};
        }
        ((IncludeFieldArray)this.includeField).add(includeField);
        return (Registration & Serializable)() -> ((IncludeFieldArray)this.includeField).remove(includeField);
    }

    private static HasComponents createDefaultContainer() {
        return new FormLayout();
    }

    protected HasComponents createContainer() {
        HasComponents c = this.view instanceof AbstractDataForm ? ((AbstractDataForm)this.view).createFieldContainer() : null;
        return c == null ? AbstractForm.createDefaultContainer() : c;
    }

    protected void generateFieldNames() {
    }

    public final HasComponents getContainer() {
        if (this.container == null) {
            this.container = this.createContainer();
            if (this.container == null) {
                this.container = AbstractForm.createDefaultContainer();
            }
            this.generateFieldNames();
            Stream<String> fieldNames = this.getFieldNames();
            if (fieldNames != null) {
                fieldNames.forEach(n -> {
                    if (this.includeField.includeField((String)n)) {
                        HasValue<?, ?> field = this.createFieldInt((String)n, this.getLabel((String)n));
                        if (n != null) {
                            this.addField((String)n, field);
                        }
                    }
                });
            }
            this.setColumns(this.columns);
            this.constructed();
            if (this.loadPending) {
                this.load();
            }
        }
        return this.container;
    }

    private HasValue<?, ?> createFieldInt(String fieldName, String label) {
        HasValue<?, ?> field = this.createField(fieldName, label);
        if (field == null && (field = this.createField(fieldName)) != null && label != null) {
            this.setFieldLabel(fieldName, label);
        }
        return field;
    }

    void customize(String fieldName, HasValue<?, ?> field) {
    }

    protected void constructed() {
        if (this.view instanceof AbstractDataForm) {
            ((AbstractDataForm)this.view).fireFormConstructed();
        }
    }

    private void addFieldInt(String fieldName, HasValue<?, ?> field) {
        if (!this.includeField.includeField(fieldName)) {
            return;
        }
        this.data.addField(fieldName, field);
        this.customize(fieldName, field);
        this.attachF(fieldName, field);
    }

    public final Component getComponent() {
        this.getContainer();
        return this.container instanceof Component ? (Component)this.container : null;
    }

    protected Stream<String> getFieldNames() {
        return this.view instanceof AbstractDataForm ? ((AbstractDataForm)this.view).getFieldNames() : null;
    }

    protected HasValue<?, ?> createField(String fieldName) {
        return this.view instanceof AbstractDataForm ? ((AbstractDataForm)this.view).createField(fieldName) : null;
    }

    protected HasValue<?, ?> createField(String fieldName, String label) {
        return this.view instanceof AbstractDataForm ? ((AbstractDataForm)this.view).createField(fieldName, label) : null;
    }

    public void addField(HasValue<?, ?> field) {
        this.attachF(this.data.addField(field), field);
    }

    public void addFields(HasValue<?, ?> ... fields) {
        if (fields != null) {
            for (HasValue<?, ?> f : fields) {
                if (f == null) continue;
                this.addField(f);
            }
        }
    }

    public void addField(String fieldName, HasValue<?, ?> field) {
        this.addFieldInt(fieldName, field);
    }

    public void removeField(String fieldName) {
        this.detachF(fieldName, this.data.removeField(fieldName));
    }

    public void removeField(String ... fieldNames) {
        for (String id : fieldNames) {
            this.removeField(id);
        }
    }

    public void removeField(HasValue<?, ?> field) {
        String fieldName = this.data.getName(field);
        if (fieldName != null) {
            this.data.removeField(fieldName);
            this.detachF(fieldName, field);
        }
    }

    private void attachF(String fieldName, HasValue<?, ?> field) {
        if (fieldName != null && field != null) {
            this.attachField(fieldName, field);
            if (field instanceof ViewDependent && this.view != null) {
                ((ViewDependent)field).setDependentView(this.view);
            }
            if (this.view instanceof AbstractDataForm) {
                ((AbstractDataForm)this.view).fieldAttached(fieldName, field);
            }
        }
    }

    private void detachF(String fieldName, HasValue<?, ?> field) {
        if (fieldName != null && field != null) {
            this.detachField(fieldName, field);
            if (this.view instanceof AbstractDataForm) {
                ((AbstractDataForm)this.view).fieldDetached(fieldName, field);
            }
        }
    }

    protected void attachField(String fieldName, HasValue<?, ?> field) {
        if (this.view instanceof AbstractDataForm) {
            try {
                ((AbstractDataForm)this.view).attachField(fieldName, field);
                return;
            }
            catch (AbstractDataForm.FieldError fieldError) {
                // empty catch block
            }
        }
        if (field instanceof Component) {
            this.getContainer().add(new Component[]{(Component)field});
        }
    }

    protected void detachField(String fieldName, HasValue<?, ?> field) {
        if (this.view instanceof AbstractDataForm) {
            try {
                ((AbstractDataForm)this.view).detachField(fieldName, field);
                return;
            }
            catch (AbstractDataForm.FieldError fieldError) {
                // empty catch block
            }
        }
        if (field instanceof Component) {
            this.getContainer().remove(new Component[]{(Component)field});
        }
    }

    public void add(Component ... components) {
        this.getContainer().add(components);
    }

    public void remove(Component ... components) {
        this.getContainer().remove(components);
    }

    public void removeAll() {
        this.getContainer().removeAll();
    }

    public void setColumns(int columns) {
        if (this.container instanceof FormLayout) {
            ((FormLayout)this.container).setColumns(columns);
        }
        this.columns = columns;
    }

    public final int getColumns() {
        if (this.container instanceof FormLayout) {
            return ((FormLayout)this.container).getColumns();
        }
        return this.columns;
    }

    public void newLine() {
        if (this.container instanceof FormLayout) {
            ((FormLayout)this.container).newLine();
        }
    }

    public void setColumnSpan(Component component, int columnSpan) {
        component.getElement().setAttribute("colspan", "" + Math.min(Math.max(1, columnSpan), this.getColumns()));
    }

    public int getColumnSpan(Component component) {
        try {
            return Integer.parseInt(component.getElement().getAttribute("colspan"));
        }
        catch (Throwable error) {
            return 1;
        }
    }

    public void load() {
        if (this.container == null) {
            this.loadPending = true;
            return;
        }
        this.data.loadValues();
    }

    public boolean commit() {
        return this.data.saveValues();
    }

    public void dumpValues() {
        this.data.forEach((k, v) -> System.err.println(k + " = " + String.valueOf(v)));
    }

    public final Stream<HasValue<?, ?>> streamFieldsCreated() {
        return this.data.getFields();
    }

    public final Stream<String> streamFieldNamesCreated() {
        return this.data.getFieldNames();
    }

    public final HasValue<?, ?> getField(String fieldName) {
        return this.data.getField(fieldName);
    }

    public final String getFieldName(HasValue<?, ?> field) {
        return this.data.getName(field);
    }

    public void setRequired(HasValue<?, ?> field) {
        this.setRequired(field, true, null);
    }

    public void setRequired(String fieldName) {
        this.setRequired(fieldName, true, null);
    }

    public void setRequired(HasValue<?, ?> field, String errorMessage) {
        this.setRequired(field, true, errorMessage);
    }

    public void setRequired(String fieldName, String errorMessage) {
        this.setRequired(fieldName, true, errorMessage);
    }

    public void setRequired(HasValue<?, ?> field, boolean required) {
        this.setRequired(field, required, null);
    }

    public void setRequired(String fieldName, boolean required) {
        this.setRequired(fieldName, required, null);
    }

    public void setRequired(HasValue<?, ?> field, boolean required, String errorMessage) {
        this.data.setRequired(field, required, errorMessage);
    }

    public void setRequired(String fieldName, boolean required, String errorMessage) {
        this.setRequired(this.getField(fieldName), required, errorMessage);
    }

    public <F> void addValidator(HasValue<?, F> field, Function<F, Boolean> validator) {
        this.addValidator(field, validator, null);
    }

    public <F> void addValidator(HasValue<?, F> field, Function<F, Boolean> validator, String errorMessage) {
        this.data.addValidator(field, validator, errorMessage);
    }

    public static void markError(HasValue<?, ?> field) {
        AbstractForm.setInvalid(field, true);
    }

    public static void clearError(HasValue<?, ?> field) {
        AbstractForm.setInvalid(field, false);
    }

    private static void setInvalid(HasValue<?, ?> field, boolean invalid) {
        if (field instanceof Element) {
            ((Element)field).setAttribute("invalid", invalid);
        }
    }

    public void clearFields() {
        this.data.clearFields();
    }

    public void clearErrors() {
        this.data.clearErrors();
        this.data.getErrorDisplay().setText(null);
    }

    public void setErrorDisplay(HasText display) {
        this.data.setErrorDisplay(display);
    }

    public HasText getErrorDisplay() {
        return this.data.getErrorDisplay();
    }

    public void setReadOnly(boolean readOnly) {
        this.data.setReadOnly(readOnly);
    }

    public boolean isReadOnly() {
        return this.data.isReadOnly();
    }

    public boolean isFieldVisible(String fieldName) {
        if (this.view instanceof AbstractDataForm) {
            return ((AbstractDataForm)this.view).isFieldVisible(fieldName);
        }
        return true;
    }

    public boolean isFieldVisible(HasValue<?, ?> field) {
        if (this.view instanceof AbstractDataForm) {
            return ((AbstractDataForm)this.view).isFieldVisible(field);
        }
        return true;
    }

    public boolean isFieldEditable(String fieldName) {
        if (this.view instanceof AbstractDataForm) {
            return ((AbstractDataForm)this.view).isFieldEditable(fieldName);
        }
        return true;
    }

    public boolean isFieldEditable(HasValue<?, ?> field) {
        if (this.view instanceof AbstractDataForm) {
            return ((AbstractDataForm)this.view).isFieldEditable(field);
        }
        return true;
    }

    public String getLabel(String fieldName) {
        if (this.view instanceof AbstractDataForm) {
            try {
                return ((AbstractDataForm)this.view).getLabel(fieldName);
            }
            catch (AbstractDataForm.FieldError fieldError) {
                // empty catch block
            }
        }
        return Objects.requireNonNull(ApplicationEnvironment.get()).createLabel(fieldName);
    }

    public final void setFieldLabel(String fieldName, String label) {
        this.setFieldLabel(this.getField(fieldName), label);
    }

    public final void setFieldLabel(HasValue<?, ?> field, String label) {
        if (field == null) {
            return;
        }
        try {
            field.getClass().getMethod("setLabel", String.class).invoke(field, label);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final String getFieldLabel(String fieldName) {
        return fieldName == null ? null : this.getFieldLabel(this.getField(fieldName));
    }

    public final String getFieldLabel(HasValue<?, ?> field) {
        return field == null ? null : Data.getLabel(field);
    }

    public boolean connect(String ... fieldNames) {
        ArrayList fieldList = new ArrayList();
        for (String fieldName : fieldNames) {
            HasValue<?, ?> field = this.getField(fieldName);
            if (field == null) continue;
            fieldList.add(field);
        }
        return this.connect(fieldList);
    }

    public boolean connect(HasValue<?, ?> ... fields) {
        ArrayList fieldList = new ArrayList();
        Collections.addAll(fieldList, fields);
        return this.connect(fieldList);
    }

    public boolean connect(Collection<HasValue<?, ?>> fields) {
        return this.data.connect(fields);
    }

    public void setView(View view) {
        this.view = view;
    }

    public View getView() {
        return this.view;
    }

    protected D createObjectInstance() {
        try {
            return this.objectClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    public D getObject() {
        return this.getObject(true);
    }

    public D getObject(boolean create) {
        if (this.objectData == null && create) {
            this.objectData = this.createObjectInstance();
        }
        return this.objectData;
    }

    public void setObject(D object) {
        this.setObject(object, true);
    }

    public void setObject(D object, boolean load) {
        this.objectData = object;
        if (load) {
            if (object == null) {
                this.clearFields();
            } else {
                this.load();
            }
        }
    }

    protected class ValueHandler
    implements FieldValueHandler {
        protected ValueHandler() {
        }

        @Override
        public boolean isBasic() {
            return true;
        }

        @Override
        public boolean canHandle(String fieldName) {
            return false;
        }

        @Override
        public boolean canSet(String fieldName) {
            return true;
        }

        @Override
        public Object getValue(String fieldName) {
            return null;
        }

        @Override
        public void setValue(String fieldName, Object value) {
        }

        @Override
        public boolean isVisible(String fieldName) {
            return AbstractForm.this.isFieldVisible(fieldName);
        }

        @Override
        public boolean isVisible(HasValue<?, ?> field) {
            return AbstractForm.this.isFieldVisible(field);
        }

        @Override
        public boolean isEditable(String fieldName) {
            return AbstractForm.this.isFieldEditable(fieldName);
        }

        @Override
        public boolean isEditable(HasValue<?, ?> field) {
            return AbstractForm.this.isFieldEditable(field);
        }
    }

    private static class IncludeFieldArray
    extends ArrayList<IncludeField>
    implements IncludeField {
        private IncludeFieldArray() {
        }

        @Override
        public boolean includeField(String fieldName) {
            return this.stream().allMatch(i -> i.includeField(fieldName));
        }
    }
}

