/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.AbstractForm;
import com.storedobject.vaadin.ConstructedListener;
import com.storedobject.vaadin.FieldCustomizer;
import com.storedobject.vaadin.HasContainer;
import com.storedobject.vaadin.HasVisibility;
import com.storedobject.vaadin.IncludeField;
import com.storedobject.vaadin.ObjectForm;
import com.storedobject.vaadin.View;
import com.storedobject.vaadin.util.Data;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class AbstractDataForm<D>
extends View
implements HasContainer {
    static final FieldError FIELD_ERROR = new FieldError();
    protected AbstractForm<D> form;
    private List<ConstructedListener> constructedListeners;
    private boolean formCreated = false;
    private HasContainer fieldContainerProvider;
    private final Set<String> readOnly = new HashSet<String>();
    private final Set<String> hidden = new HashSet<String>();
    private final Set<HasValue<?, ?>> readOnlyFields = new HashSet();
    private final Set<HasValue<?, ?>> hiddenFields = new HashSet();

    public AbstractForm<D> getForm() {
        return this.form;
    }

    protected void formConstructed() {
    }

    protected final void fireFormConstructed() {
        this.formCreated = true;
        this.formConstructed();
        if (this.constructedListeners != null) {
            this.constructedListeners.forEach(cl -> cl.constructed(this));
            this.constructedListeners = null;
        }
    }

    public Registration addConstructedListener(ConstructedListener constructedListener) {
        if (this.formCreated) {
            constructedListener.constructed(this);
            return (Registration & Serializable)() -> {};
        }
        if (this.constructedListeners == null) {
            this.constructedListeners = new ArrayList<ConstructedListener>();
        }
        this.constructedListeners.add(constructedListener);
        return (Registration & Serializable)() -> this.constructedListeners.remove(constructedListener);
    }

    protected final Data<D> getData() {
        return this.form.data;
    }

    @Override
    public Component getContent() {
        return this.form.getComponent();
    }

    public void setFieldContainerProvider(HasContainer fieldContainerProvider) {
        this.fieldContainerProvider = fieldContainerProvider;
    }

    protected HasComponents createFieldContainer() {
        return this.fieldContainerProvider == null ? null : this.fieldContainerProvider.getContainer();
    }

    protected HasComponents createLayout() {
        return null;
    }

    protected HasComponents createButtonLayout() {
        return null;
    }

    @Override
    public HasComponents getContainer() {
        return this.form.getContainer();
    }

    public Stream<String> getFieldNames() {
        return null;
    }

    public void setIncludeFieldChecker(IncludeField includeField) {
        this.getForm().setIncludeFieldChecker(includeField);
    }

    public Registration addIncludeFieldChecker(IncludeField includeField) {
        return this.getForm().addIncludeFieldChecker(includeField);
    }

    public void setFieldCustomizer(FieldCustomizer fieldCustomizer) {
        ((ObjectForm)this.form).setFieldCustomizer(fieldCustomizer);
    }

    protected HasValue<?, ?> createField(String fieldName) {
        return null;
    }

    protected HasValue<?, ?> createField(String fieldName, String label) {
        return null;
    }

    public void addField(HasValue<?, ?> ... fields) {
        if (fields != null) {
            for (HasValue<?, ?> field : fields) {
                this.form.addField(field);
            }
        }
    }

    public void addField(String fieldName, HasValue<?, ?> field) {
        this.form.addField(fieldName, field);
    }

    public void removeField(String fieldName) {
        this.form.removeField(fieldName);
    }

    public void removeField(String ... fieldNames) {
        this.form.removeField(fieldNames);
    }

    public void removeField(HasValue<?, ?> field) {
        this.form.removeField(field);
    }

    public void add(Component ... components) {
        this.form.add(components);
    }

    public void remove(Component ... components) {
        this.form.remove(components);
    }

    public void removeAll() {
        this.form.removeAll();
    }

    public void load() {
        this.form.load();
    }

    public boolean commit() {
        return this.form.commit();
    }

    public HasValue<?, ?> getField(String fieldName) {
        return this.form.getField(fieldName);
    }

    public String getFieldName(HasValue<?, ?> field) {
        return this.form.getFieldName(field);
    }

    public void setRequired(HasValue<?, ?> ... fields) {
        if (fields != null) {
            for (HasValue<?, ?> field : fields) {
                if (field == null) continue;
                this.form.setRequired(field);
            }
        }
    }

    public void setRequired(HasValue<?, ?> field) {
        this.form.setRequired(field);
    }

    public void setRequired(String fieldName) {
        this.form.setRequired(fieldName);
    }

    public void setRequired(HasValue<?, ?> field, String errorMessage) {
        this.form.setRequired(field, errorMessage);
    }

    public void setRequired(String fieldName, String errorMessage) {
        this.form.setRequired(fieldName, errorMessage);
    }

    public void setRequired(HasValue<?, ?> field, boolean required) {
        this.form.setRequired(field, required);
    }

    public void setRequired(String fieldName, boolean required) {
        this.form.setRequired(fieldName, required);
    }

    public void setRequired(HasValue<?, ?> field, boolean required, String errorMessage) {
        this.form.setRequired(field, required, errorMessage);
    }

    public void setRequired(String fieldName, boolean required, String errorMessage) {
        this.form.setRequired(fieldName, required, errorMessage);
    }

    public <T> void addValidator(HasValue<?, T> field, Function<T, Boolean> validator) {
        this.form.addValidator(field, validator);
    }

    public <T> void addValidator(HasValue<?, T> field, Function<T, Boolean> validator, String errorMessage) {
        this.form.addValidator(field, validator, errorMessage);
    }

    public static void markError(HasValue<?, ?> field) {
        AbstractForm.markError(field);
    }

    public static void clearError(HasValue<?, ?> field) {
        AbstractForm.clearError(field);
    }

    public void clearFields() {
        this.form.clearFields();
    }

    public void clearErrors() {
        this.form.clearErrors();
    }

    public void setReadOnly(boolean readOnly) {
        this.form.setReadOnly(readOnly);
    }

    public boolean isReadOnly() {
        return this.form.isReadOnly();
    }

    public boolean isFieldVisible(String fieldName) {
        return !this.hidden.contains(fieldName);
    }

    public boolean isFieldVisible(HasValue<?, ?> field) {
        return !this.hiddenFields.contains(field);
    }

    public void setFieldVisible(String ... fieldNames) {
        if (fieldNames == null || fieldNames.length == 0) {
            return;
        }
        for (String fieldName : fieldNames) {
            if (fieldName == null || fieldName.isEmpty()) continue;
            this.hidden.remove(fieldName);
            HasValue<?, ?> field = this.form.getField(fieldName);
            if (field == null) continue;
            this.hiddenFields.remove(field);
            HasVisibility.setVisible(true, field);
        }
    }

    public void setFieldVisible(HasValue<?, ?> ... fields) {
        if (fields == null || fields.length == 0) {
            return;
        }
        for (HasValue<?, ?> field : fields) {
            if (field == null) continue;
            String fieldName = this.form.getFieldName(field);
            if (fieldName != null) {
                this.hidden.remove(fieldName);
            }
            this.hiddenFields.remove(field);
            HasVisibility.setVisible(true, field);
        }
    }

    public void setFieldVisible(boolean visible, String ... fieldNames) {
        if (visible) {
            this.setFieldVisible(fieldNames);
        } else {
            this.setFieldHidden(fieldNames);
        }
    }

    public void setFieldVisible(boolean visible, HasValue<?, ?> ... fields) {
        if (visible) {
            this.setFieldVisible(fields);
        } else {
            this.setFieldHidden(fields);
        }
    }

    public void setFieldHidden(String ... fieldNames) {
        if (fieldNames == null || fieldNames.length == 0) {
            return;
        }
        for (String fieldName : fieldNames) {
            if (fieldName == null || fieldName.isEmpty()) continue;
            this.hidden.add(fieldName);
            HasValue<?, ?> field = this.form.getField(fieldName);
            if (field == null) continue;
            HasVisibility.setVisible(false, field);
            this.hiddenFields.add(field);
        }
    }

    public void setFieldHidden(HasValue<?, ?> ... fields) {
        if (fields == null || fields.length == 0) {
            return;
        }
        for (HasValue<?, ?> field : fields) {
            if (field == null) continue;
            HasVisibility.setVisible(false, field);
            String fieldName = this.form.getFieldName(field);
            if (fieldName != null) {
                this.hidden.add(fieldName);
            }
            this.hiddenFields.add(field);
        }
    }

    public boolean isFieldEditable(String fieldName) {
        return !this.readOnly.contains(fieldName);
    }

    public boolean isFieldEditable(HasValue<?, ?> field) {
        return !this.readOnlyFields.contains(field);
    }

    public void setFieldEditable(String ... fieldNames) {
        if (fieldNames == null || fieldNames.length == 0) {
            return;
        }
        for (String fieldName : fieldNames) {
            if (fieldName == null || fieldName.isEmpty()) continue;
            this.readOnly.remove(fieldName);
            HasValue<?, ?> field = this.form.getField(fieldName);
            if (field == null) continue;
            this.readOnlyFields.remove(field);
            if (this.isReadOnly()) continue;
            field.setReadOnly(false);
        }
    }

    public void setFieldEditable(HasValue<?, ?> ... fields) {
        if (fields == null || fields.length == 0) {
            return;
        }
        for (HasValue<?, ?> field : fields) {
            if (field == null) continue;
            String fieldName = this.form.getFieldName(field);
            if (fieldName != null) {
                this.readOnly.remove(fieldName);
            }
            this.readOnlyFields.remove(field);
            if (this.isReadOnly()) continue;
            field.setReadOnly(false);
        }
    }

    public void setFieldReadOnly(String ... fieldNames) {
        if (fieldNames == null || fieldNames.length == 0) {
            return;
        }
        for (String fieldName : fieldNames) {
            if (fieldName == null || fieldName.isEmpty()) continue;
            this.readOnly.add(fieldName);
            HasValue<?, ?> field = this.form.getField(fieldName);
            if (field == null) continue;
            field.setReadOnly(true);
            this.readOnlyFields.add(field);
        }
    }

    public void setFieldReadOnly(HasValue<?, ?> ... fields) {
        if (fields == null || fields.length == 0) {
            return;
        }
        for (HasValue<?, ?> field : fields) {
            if (field == null) continue;
            field.setReadOnly(true);
            String fieldName = this.form.getFieldName(field);
            if (fieldName != null) {
                this.readOnly.add(fieldName);
            }
            this.readOnlyFields.add(field);
        }
    }

    public void setFieldReadOnly(boolean readOnly, String ... fieldNames) {
        if (readOnly) {
            this.setFieldReadOnly(fieldNames);
        } else {
            this.setFieldEditable(fieldNames);
        }
    }

    public void setFieldReadOnly(boolean readOnly, HasValue<?, ?> ... fields) {
        if (readOnly) {
            this.setFieldReadOnly(fields);
        } else {
            this.setFieldEditable(fields);
        }
    }

    protected String getLabel(String fieldName) {
        throw FIELD_ERROR;
    }

    public final void setFieldLabel(String fieldName, String label) {
        this.form.setFieldLabel(fieldName, label);
    }

    public final void setFieldLabel(HasValue<?, ?> field, String label) {
        this.form.setFieldLabel(field, label);
    }

    public final String getFieldLabel(String fieldName) {
        return fieldName == null ? null : this.getFieldLabel(this.getField(fieldName));
    }

    public final String getFieldLabel(HasValue<?, ?> field) {
        return field == null ? null : this.form.getFieldLabel(field);
    }

    protected void attachField(String fieldName, HasValue<?, ?> field) {
        throw FIELD_ERROR;
    }

    protected void fieldAttached(String fieldName, HasValue<?, ?> field) {
    }

    protected void detachField(String fieldName, HasValue<?, ?> field) {
        throw FIELD_ERROR;
    }

    protected void fieldDetached(String fieldName, HasValue<?, ?> field) {
    }

    public void setErrorDisplay(HasText display) {
        this.form.setErrorDisplay(display);
    }

    public HasText getErrorDisplay() {
        return this.form.getErrorDisplay();
    }

    public void setColumns(int columns) {
        this.form.setColumns(columns);
    }

    public final int getColumns() {
        return this.form.getColumns();
    }

    public void newLine() {
        this.form.newLine();
    }

    public void setColumnSpan(Component component, int columnSpan) {
        this.form.setColumnSpan(component, columnSpan);
    }

    public int getColumnSpan(Component component) {
        return this.form.getColumnSpan(component);
    }

    public boolean connect(String ... fieldNames) {
        return this.form.connect(fieldNames);
    }

    public boolean connect(HasValue<?, ?> ... fields) {
        return this.form.connect(fields);
    }

    public boolean connect(Collection<HasValue<?, ?>> fields) {
        return this.form.connect(fields);
    }

    @Override
    public void clean() {
        this.getForm().data.getErrorDisplay().setText(null);
        super.clean();
    }

    public final Stream<HasValue<?, ?>> streamFieldsCreated() {
        return this.form.streamFieldsCreated();
    }

    public final Stream<String> streamFieldNamesCreated() {
        return this.form.streamFieldNamesCreated();
    }

    @Override
    public void clearAlerts() {
        super.clearAlerts();
        this.getForm().data.getErrorDisplay().setText(null);
    }

    protected static class FieldError
    extends RuntimeException {
        protected FieldError() {
        }
    }
}

