/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.vaadin;

import com.storedobject.vaadin.AbstractDataForm;
import com.storedobject.vaadin.Application;
import com.storedobject.vaadin.ObjectFieldCreator;
import com.storedobject.vaadin.ObjectForm;
import com.vaadin.flow.component.HasValue;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class AbstractDataEditor<T>
extends AbstractDataForm<T> {
    private final HashMap<Method, Object> fixedValues = new HashMap();

    public AbstractDataEditor(Class<T> objectClass) {
        this(objectClass, null);
    }

    public AbstractDataEditor(Class<T> objectClass, String caption) {
        this.form = new DForm(objectClass);
        this.setCaption(caption == null || caption.isEmpty() ? Objects.requireNonNull(Application.get()).getEnvironment().createLabel(this.getObjectClass()) : caption);
    }

    @Override
    public ObjectForm<T> getForm() {
        return (ObjectForm)super.getForm();
    }

    public Class<T> getObjectClass() {
        return ((ObjectForm)this.form).getObjectClass();
    }

    public Class<T> getDataClass() {
        return ((ObjectForm)this.form).getDataClass();
    }

    @Override
    public Stream<String> getFieldNames() {
        throw FIELD_ERROR;
    }

    protected Method getFieldGetMethod(String fieldName) {
        throw FIELD_ERROR;
    }

    protected Method getFieldSetMethod(String fieldName, Method getMethod) {
        throw FIELD_ERROR;
    }

    protected void addField(Iterable<String> fieldNames) {
        ((ObjectForm)this.getForm()).addField(fieldNames);
    }

    protected void addField(String ... fieldNames) {
        ((ObjectForm)this.getForm()).addField(fieldNames);
    }

    protected <V> String addField(HasValue<?, V> field, Function<T, V> valueGetter) {
        return ((ObjectForm)this.getForm()).addField(field, valueGetter);
    }

    protected <V> String addField(HasValue<?, V> field, Function<T, V> valueGetter, BiConsumer<T, V> valueSetter) {
        return ((ObjectForm)this.getForm()).addField(field, valueGetter, valueSetter);
    }

    @Override
    protected void addField(String fieldName, Function<T, ?> valueGetter) {
        ((ObjectForm)this.getForm()).addField(fieldName, valueGetter);
    }

    protected void addField(String fieldName, Function<T, ?> valueGetter, BiConsumer<T, ?> valueSetter) {
        ((ObjectForm)this.getForm()).addField(fieldName, valueGetter, valueSetter);
    }

    protected void addField(String fieldName, Method getMethod) {
        ((ObjectForm)this.getForm()).addField(fieldName, getMethod);
    }

    protected void addField(String fieldName, Method getMethod, Method setMethod) {
        ((ObjectForm)this.getForm()).addField(fieldName, getMethod, setMethod);
    }

    protected boolean includeField(String fieldName) {
        return true;
    }

    public final boolean isFieldIncluded(String fieldName) {
        return ((ObjectForm)this.getForm()).isFieldIncluded(fieldName);
    }

    protected void customizeField(String fieldName, HasValue<?, ?> field) {
    }

    protected HasValue<?, ?> createField(String fieldName, Class<?> fieldType, String label) {
        return null;
    }

    protected final HasValue<?, ?> constructField(String fieldName) {
        return ((ObjectForm)this.getForm()).createField(fieldName);
    }

    protected ObjectFieldCreator<T> getFieldCreator() {
        return ((ObjectForm)this.form).getFieldCreator();
    }

    protected int getFieldOrder(String fieldName) {
        throw FIELD_ERROR;
    }

    protected T createObjectInstance() {
        throw FIELD_ERROR;
    }

    public final T newObject() {
        return (T)this.getForm().createObjectInstance();
    }

    public T getObject() {
        return (T)this.form.getObject();
    }

    public void setObject(T object) {
        this.setObject(object, true);
    }

    public void setObject(T object, boolean load) {
        this.form.setObject(object, load);
    }

    public void setFixedValue(String fieldName, Object value) {
        Arrays.stream(this.getObjectClass().getMethods()).filter(m -> AbstractDataEditor.checkSetMethod(m, fieldName, value)).forEach(m -> this.fixedValues.put((Method)m, value));
    }

    private static boolean checkSetMethod(Method m, String fieldName, Object value) {
        if (!m.getName().equals("set" + fieldName) || m.getParameterCount() != 1 || !Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers())) {
            return false;
        }
        return value == null || m.getParameterTypes()[0].isAssignableFrom(value.getClass());
    }

    public void setFixedValue(HasValue<?, ?> field, Object value) {
        this.setFixedValue(this.getFieldName(field), value);
    }

    public void setFixedValues(T object) {
        if (object != null) {
            this.fixedValues.forEach((m, v) -> {
                try {
                    m.invoke(object, v);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    protected boolean handleValueSetError(String fieldName, HasValue<?, ?> field, Object fieldValue, Object objectValue, Throwable error) {
        return true;
    }

    protected class DForm
    extends ObjectForm<T> {
        public DForm(Class<T> objectClass) {
            super(objectClass);
            this.setView(AbstractDataEditor.this);
            this.setMethodHandlerHost(AbstractDataEditor.this);
        }

        @Override
        protected void generateFieldNames() {
            try {
                AbstractDataEditor.this.getFieldNames().filter(this::includeField).forEach(n -> this.addField((String)n, this.getFieldGetMethod((String)n), null));
            }
            catch (AbstractDataForm.FieldError e) {
                super.generateFieldNames();
            }
        }

        @Override
        protected Method getFieldGetMethod(String fieldName) {
            Method m;
            try {
                m = this.checkMethod(this.getFieldCreator().getFieldGetMethod(fieldName));
                if (m != null) {
                    return m;
                }
            }
            catch (AbstractDataForm.FieldError fieldError) {
                // empty catch block
            }
            try {
                return AbstractDataEditor.this.getFieldGetMethod(fieldName);
            }
            catch (AbstractDataForm.FieldError fieldError) {
                try {
                    m = this.checkMethod(AbstractDataEditor.this.getClass().getMethod("get" + fieldName, new Class[0]));
                    if (m != null) {
                        return m;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                try {
                    m = this.checkMethod(AbstractDataEditor.this.getClass().getMethod("is" + fieldName, new Class[0]));
                    if (m != null) {
                        return m;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return super.getFieldGetMethod(fieldName);
            }
        }

        @Override
        protected Method getFieldSetMethod(String fieldName, Method getMethod) {
            Method m;
            try {
                m = this.checkMethod(this.getFieldCreator().getFieldSetMethod(fieldName, getMethod));
                if (m != null) {
                    return m;
                }
            }
            catch (AbstractDataForm.FieldError fieldError) {
                // empty catch block
            }
            try {
                return AbstractDataEditor.this.getFieldSetMethod(fieldName, getMethod);
            }
            catch (AbstractDataForm.FieldError fieldError) {
                if (!"Caption".equals(fieldName)) {
                    Class[] params = new Class[]{getMethod.getReturnType()};
                    try {
                        m = this.checkMethod(AbstractDataEditor.this.getClass().getMethod("set" + fieldName, params));
                        if (m != null) {
                            return m;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                return super.getFieldSetMethod(fieldName, getMethod);
            }
        }

        @Override
        protected HasValue<?, ?> createField(String fieldName, Class<?> fieldType, String label) {
            HasValue<?, ?> field = AbstractDataEditor.this.createField(fieldName, fieldType, label);
            return field == null ? super.createField(fieldName, fieldType, label) : field;
        }

        @Override
        protected boolean includeField(String fieldName) {
            return AbstractDataEditor.this.includeField(fieldName) && super.includeField(fieldName);
        }

        @Override
        protected int getFieldOrder(String fieldName) {
            try {
                return AbstractDataEditor.this.getFieldOrder(fieldName);
            }
            catch (AbstractDataForm.FieldError e) {
                return super.getFieldOrder(fieldName);
            }
        }

        @Override
        protected T createObjectInstance() {
            Object object;
            try {
                object = AbstractDataEditor.this.createObjectInstance();
            }
            catch (AbstractDataForm.FieldError e) {
                object = super.createObjectInstance();
            }
            AbstractDataEditor.this.setFixedValues(object);
            return object;
        }

        @Override
        protected void customizeField(String fieldName, HasValue<?, ?> field) {
            AbstractDataEditor.this.customizeField(fieldName, field);
            super.customizeField(fieldName, field);
        }

        @Override
        protected boolean handleValueSetError(String fieldName, HasValue<?, ?> field, Object fieldValue, Object objectValue, Throwable error) {
            return AbstractDataEditor.this.handleValueSetError(fieldName, field, fieldValue, objectValue, error);
        }
    }
}

