/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.ChartType;
import com.storedobject.chart.GraphData;
import com.storedobject.chart.XYChart;

public class XYGraphChart
extends XYChart {
    private final GraphData<GraphData.ValueNode> graphData;
    private final AbstractDataProvider<?> xData;

    public XYGraphChart(AbstractDataProvider<?> xData, GraphData<GraphData.ValueNode> graphData) {
        super(ChartType.XYGraph, xData, (AbstractDataProvider<?>)graphData.getNodeData(false));
        this.xData = xData;
        this.graphData = graphData;
    }

    @Override
    public void validate() throws ChartException {
        super.validate();
        if (this.graphData.isEmpty()) {
            throw new ChartException("Data not set for " + this.className());
        }
        this.getCoordinateSystem().getAxis(0).setData(this.xData);
    }

    @Override
    protected AbstractDataProvider<?> dataToEmbed() {
        return this.graphData.getNodeData(false);
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        this.graphData.encodeJSON(sb);
    }
}

