/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.TreeDataProvider;
import com.storedobject.helper.ID;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class TreeData
implements TreeDataProvider {
    private final long id = ID.newID();
    private int serial;
    private final String name;
    private Number value;
    private TreeDataProvider.Label label;
    private List<TreeData> children;

    public TreeData(String name) {
        this(name, null);
    }

    public TreeData(String name, Number value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Number getValue() {
        return this.value;
    }

    public void setValue(Number value) {
        this.value = value;
    }

    @Override
    public Stream<? extends TreeDataProvider> getChildren() {
        return this.children == null ? null : this.children.stream();
    }

    @Override
    public final long getId() {
        return this.id;
    }

    @Override
    public void setSerial(int serial) {
        this.serial = serial;
    }

    @Override
    public int getSerial() {
        return this.serial;
    }

    public TreeData add(TreeData ... treeData) {
        if (treeData != null) {
            for (TreeData td : treeData) {
                if (td == null) continue;
                if (this.children == null) {
                    this.children = new ArrayList<TreeData>();
                }
                this.children.add(td);
            }
        }
        return this;
    }

    public TreeData add(String name, Number value) {
        return this.add(new TreeData(name, value));
    }

    public TreeData remove(TreeData ... treeData) {
        if (treeData != null && this.children != null) {
            for (TreeData td : treeData) {
                if (td == null) continue;
                this.children.remove(td);
            }
        }
        return this;
    }

    public TreeData get(int index) {
        return this.children != null && index >= 0 && index < this.children.size() ? this.children.get(index) : null;
    }

    @Override
    public final TreeDataProvider.Label getLabel(boolean create) {
        if (this.label == null && create) {
            this.label = new TreeDataProvider.Label();
        }
        return this.label;
    }

    public void setLabel(TreeDataProvider.Label label) {
        this.label = label;
    }
}

