/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.DataType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Comparator;
import java.util.Date;

public interface TimeDataProvider
extends AbstractDataProvider<LocalDateTime> {
    @Override
    default public DataType getDataType() {
        return DataType.TIME;
    }

    public boolean add(LocalDateTime var1);

    default public boolean add(LocalDate date) {
        if (date == null) {
            return false;
        }
        return this.add(date.atStartOfDay());
    }

    default public boolean add(Date date) {
        if (date == null) {
            return false;
        }
        return this.add(date.getTime());
    }

    default public boolean add(long timeInMillis) {
        long nanos = (timeInMillis - timeInMillis / 1000L * 1000L) * 1000L;
        return this.add(LocalDateTime.ofEpochSecond(timeInMillis / 1000L, (int)nanos, ZoneOffset.UTC));
    }

    @Override
    default public Comparator<LocalDateTime> getComparator() {
        return (d1, d2) -> {
            if (d1 == null || d2 == null) {
                return d1 == null && d2 == null ? 0 : (d1 == null ? -1 : 1);
            }
            return d1.isBefore((ChronoLocalDateTime<?>)d2) ? -1 : (d1.isAfter((ChronoLocalDateTime<?>)d2) ? 1 : 0);
        };
    }
}

