/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.Chart;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.ChartType;
import com.storedobject.chart.DataType;
import com.storedobject.chart.HasPolarProperty;
import com.storedobject.chart.HasPosition;
import com.storedobject.chart.InternalDataProvider;
import com.storedobject.chart.PolarProperty;
import com.storedobject.chart.Position;
import com.storedobject.chart.TreeDataProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class SunburstChart
extends Chart
implements HasPosition,
HasPolarProperty {
    private final List<TreeDataProvider> data = new ArrayList<TreeDataProvider>();
    private Position position;
    private final TD td = new TD();
    private PolarProperty polarProperty;

    public SunburstChart(TreeDataProvider ... data) {
        super(ChartType.Sunburst, new AbstractDataProvider[0]);
        super.setData(this.td);
        this.addData(data);
    }

    @Override
    public void setData(AbstractDataProvider<?> ... data) {
    }

    public List<TreeDataProvider> getSunburstData() {
        return this.data;
    }

    public void addData(TreeDataProvider ... data) {
        if (data != null) {
            this.data.addAll(Arrays.asList(data));
        }
    }

    public void removeData(TreeDataProvider ... data) {
        if (data != null) {
            this.data.removeAll(Arrays.asList(data));
        }
    }

    @Override
    public void validate() throws ChartException {
        super.validate();
        if (this.data.isEmpty()) {
            throw new ChartException("No data provided for " + this.className());
        }
    }

    @Override
    protected AbstractDataProvider<?> dataToEmbed() {
        return this.td;
    }

    @Override
    public final Position getPosition(boolean create) {
        if (this.position == null && create) {
            this.position = new Position();
        }
        return this.position;
    }

    @Override
    public final void setPosition(Position position) {
        this.position = position;
    }

    @Override
    public final PolarProperty getPolarProperty(boolean create) {
        if (this.polarProperty == null && create) {
            this.polarProperty = new PolarProperty();
        }
        return this.polarProperty;
    }

    @Override
    public final void setPolarProperty(PolarProperty polarProperty) {
        this.polarProperty = polarProperty;
    }

    private class TD
    implements AbstractDataProvider<Object>,
    InternalDataProvider {
        private int serial = -1;

        private TD() {
        }

        @Override
        public Stream<Object> stream() {
            return SunburstChart.this.data.stream().map(o -> o);
        }

        @Override
        public void encode(StringBuilder sb, Object value) {
            ((TreeDataProvider)value).encodeJSON(sb);
        }

        @Override
        public DataType getDataType() {
            return DataType.OBJECT;
        }

        @Override
        public void setSerial(int serial) {
            this.serial = serial;
        }

        @Override
        public int getSerial() {
            return this.serial;
        }
    }
}

