/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import java.util.Objects;

public class Size {
    private int size;

    Size() {
        this(Integer.MIN_VALUE);
    }

    Size(int size) {
        this.size = size;
    }

    int get() {
        return this.size;
    }

    void set(Size size) {
        this.size = size.size;
    }

    void set(int size) {
        this.size = size;
    }

    void left() {
        this.size = -101;
    }

    void center() {
        this.size = -102;
    }

    void right() {
        this.size = -103;
    }

    void top() {
        this.size = -111;
    }

    void middle() {
        this.size = -112;
    }

    void bottom() {
        this.size = -113;
    }

    boolean isNull() {
        return this.size == Integer.MIN_VALUE;
    }

    int plus(int add) {
        if (this.size == Integer.MIN_VALUE) {
            return add;
        }
        if (this.size >= 0) {
            return this.size + add;
        }
        if (this.size >= -100) {
            if ((add -= this.size) > 100) {
                add = 100;
            }
            return -add;
        }
        return this.size;
    }

    String encode() {
        if (this.size == Integer.MIN_VALUE) {
            return null;
        }
        switch (this.size) {
            case -101: {
                return "\"left\"";
            }
            case -102: {
                return "\"center\"";
            }
            case -103: {
                return "\"right\"";
            }
            case -111: {
                return "\"top\"";
            }
            case -112: {
                return "\"middle\"";
            }
            case -113: {
                return "\"bottom\"";
            }
        }
        if (this.size < 0) {
            return "\"" + -this.size + "%\"";
        }
        return "" + this.size;
    }

    static String code(int size) {
        return new Size(size).encode();
    }

    public static Size pixels(int pixels) {
        return new Size(Math.max(0, pixels));
    }

    public static Size percentage(int percentage) {
        return new Size(-Math.min(100, percentage));
    }

    public static Size none() {
        return new Size(Integer.MIN_VALUE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Size size1 = (Size)o;
        return this.size == size1.size;
    }

    public int hashCode() {
        return Objects.hash(this.size);
    }

    public String toString() {
        return this.encode();
    }
}

