/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ShapeGroup
extends Shape {
    private final List<Shape> shapes = new ArrayList<Shape>();

    @Override
    protected final String getType() {
        return "group";
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        int z = -1;
        int myZ = this.getZ();
        sb.append("\"children\":[");
        for (int i = 0; i < this.shapes.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            Shape child = this.shapes.get(i);
            sb.append('{');
            if (myZ >= 0 && (z = child.getZ()) < 0) {
                child.setZ(myZ);
            }
            child.encodeJSON(sb);
            if (myZ >= 0) {
                child.setZ(z);
            }
            sb.append('}');
        }
        sb.append(']');
    }

    public void add(Shape ... shapes) {
        if (shapes != null && shapes.length > 0) {
            this.shapes.addAll(Arrays.asList(shapes));
            this.shapes.removeIf(Objects::isNull);
        }
    }

    public void remove(Shape ... shapes) {
        if (shapes != null && shapes.length > 0) {
            for (Shape shape : shapes) {
                if (shape == null) continue;
                this.shapes.remove(shape);
            }
        }
    }
}

