/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.Alignment;
import com.storedobject.chart.Chart;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.ChartType;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.DataType;
import com.storedobject.chart.InternalDataProvider;
import com.storedobject.chart.LineStyle;
import com.storedobject.chart.SankeyData;
import com.storedobject.chart.SankeyDataProvider;
import com.storedobject.chart.SelfPositioningSpecialChart;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

public class SankeyChart
extends SelfPositioningSpecialChart {
    private SankeyDataProvider data;
    private final SD sd;
    private boolean horizontal = true;
    private int width = 0;
    private int height = 0;
    private int nodeWidth = 0;
    private int nodeGap = 0;
    private Alignment nodeAlignment;
    private Chart.Label edgeLabel;
    private LineStyle lineStyle;

    public SankeyChart(SankeyDataProvider data) {
        super(ChartType.Sankey, new AbstractDataProvider[0]);
        this.data = data;
        AbstractDataProvider[] abstractDataProviderArray = new AbstractDataProvider[1];
        this.sd = new SD();
        abstractDataProviderArray[0] = this.sd;
        super.setData(abstractDataProviderArray);
    }

    @Override
    public final void setData(AbstractDataProvider<?> ... data) {
    }

    public SankeyDataProvider getSankeyData() {
        return this.data;
    }

    public void setSankeyData(SankeyDataProvider data) {
        this.data = data;
    }

    @Override
    protected AbstractDataProvider<?> dataToEmbed() {
        return this.sd;
    }

    public final void setVertical() {
        this.horizontal = false;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public final void setWidth(int width) {
        this.width = width;
    }

    public final void setNodeWidth(int nodeWidth) {
        this.nodeWidth = nodeWidth;
    }

    public final void setNodeGap(int nodeGap) {
        this.nodeGap = nodeGap;
    }

    public final void setNodeAlignment(Alignment nodeAlignment) {
        this.nodeAlignment = nodeAlignment;
    }

    public final Alignment getNodeAlignment(boolean create) {
        if (this.nodeAlignment == null && create) {
            this.nodeAlignment = new Alignment();
        }
        return this.nodeAlignment;
    }

    public final void setEdgeLabel(Chart.Label edgeLabel) {
        this.edgeLabel = edgeLabel;
    }

    public final Chart.Label getEdgeLabel(boolean create) {
        if (this.edgeLabel == null && create) {
            this.edgeLabel = new Chart.Label();
        }
        return this.edgeLabel;
    }

    public final void setLineStyle(LineStyle lineStyle) {
        this.lineStyle = lineStyle;
    }

    public final LineStyle getLineStyle(boolean create) {
        if (this.lineStyle == null && create) {
            this.lineStyle = new LineStyle();
        }
        return this.lineStyle;
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        if (!this.horizontal) {
            ComponentPart.encode(sb, "orient", "vertical");
        }
        ComponentPart.addComma(sb);
        sb.append("\"edges\":[");
        AtomicBoolean first = new AtomicBoolean(true);
        this.data.getEdges().forEach(e -> {
            if (first.get()) {
                first.set(false);
            } else {
                sb.append(',');
            }
            sb.append('{');
            e.encodeJSON(sb);
            sb.append('}');
        });
        sb.append(']');
        if (this.width > 0) {
            ComponentPart.encode(sb, "width", this.width);
        }
        if (this.height > 0) {
            ComponentPart.encode(sb, "height", this.height);
        }
        if (this.nodeWidth > 0) {
            ComponentPart.encode(sb, "nodeWidth", this.nodeWidth);
        }
        if (this.nodeGap > 0) {
            ComponentPart.encode(sb, "nodeGap", this.nodeGap);
        }
        if (this.nodeAlignment != null) {
            ComponentPart.encode(sb, "align", this.nodeAlignment);
        }
        if (this.edgeLabel != null) {
            ComponentPart.encode(sb, "edgeLabel", this.edgeLabel);
        }
        if (this.lineStyle != null) {
            ComponentPart.encode(sb, "lineStyle", this.lineStyle);
        }
    }

    private class SD
    implements AbstractDataProvider<Object>,
    InternalDataProvider {
        private int serial = -1;

        private SD() {
        }

        @Override
        public Stream<Object> stream() {
            return SankeyChart.this.data.getNodes().map(o -> o);
        }

        @Override
        public void encode(StringBuilder sb, Object value) {
            sb.append('{');
            ((SankeyData.Node)value).encodeJSON(sb);
            sb.append('}');
        }

        @Override
        public DataType getDataType() {
            return DataType.OBJECT;
        }

        @Override
        public void setSerial(int serial) {
            this.serial = serial;
        }

        @Override
        public int getSerial() {
            return this.serial;
        }

        @Override
        public void validate() throws ChartException {
            SankeyChart.this.data.validate();
        }
    }
}

