/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.TextStyle;
import java.util.HashMap;
import java.util.Map;

public class RichTextStyle {
    final Map<String, TextStyle> parts = new HashMap<String, TextStyle>();

    public TextStyle get(String partName, boolean create) {
        if (partName == null) {
            return null;
        }
        TS ts = (TS)this.parts.get(partName = RichTextStyle.sanitizeName(partName));
        if (ts == null && create) {
            ts = new TS();
            this.parts.put(partName, ts);
        }
        return ts;
    }

    public void add(String partName, TextStyle textStyle) {
        if (!(textStyle instanceof TS)) {
            throw new RuntimeException("No a rich text style!");
        }
        if (partName == null) {
            return;
        }
        partName = RichTextStyle.sanitizeName(partName);
        this.parts.put(partName, textStyle);
    }

    public void remove(String partName) {
        if (partName != null) {
            this.parts.remove(RichTextStyle.sanitizeName(partName));
        }
    }

    private static String sanitizeName(String partName) {
        partName = ((String)partName).strip();
        StringBuilder sb = new StringBuilder();
        ((String)partName).chars().forEach(c -> {
            if (Character.isLetterOrDigit(c)) {
                sb.append((char)c);
            } else {
                sb.append('_');
            }
        });
        partName = sb.toString();
        if (((String)partName).isEmpty()) {
            return "part";
        }
        if (Character.isDigit(((String)partName).charAt(0))) {
            partName = "part_" + (String)partName;
        }
        return partName;
    }

    private static class TS
    extends TextStyle {
        private TS() {
        }

        @Override
        public RichTextStyle getRichTextStyle(boolean create) {
            return null;
        }

        @Override
        public void setRichTextStyle(RichTextStyle richTextStyle) {
        }
    }
}

