/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractColor;
import com.storedobject.chart.Axis;
import com.storedobject.chart.CategoryDataProvider;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.CoordinateSystem;
import com.storedobject.chart.HasPolarProperty;
import com.storedobject.chart.PolarProperty;
import com.storedobject.chart.RadarAxis;
import java.util.concurrent.atomic.AtomicBoolean;

public class RadarCoordinate
extends CoordinateSystem
implements HasPolarProperty {
    private PolarProperty polarProperty;
    private CategoryDataProvider axisIndicators;
    private int startingAngle = 90;
    private AbstractColor color;
    private RadarAxis axis;
    private boolean circular;

    public RadarCoordinate() {
        this(null, null);
    }

    public RadarCoordinate(CategoryDataProvider axisIndicators) {
        this(null, axisIndicators);
    }

    public RadarCoordinate(RadarAxis axis) {
        this(axis, null);
    }

    public RadarCoordinate(RadarAxis axis, CategoryDataProvider axisIndicators) {
        this.axisIndicators = axisIndicators;
        this.setAxis(axis);
    }

    @Override
    public void addAxis(Axis ... axes) {
    }

    public void setAxis(RadarAxis axis) {
        this.axis = axis;
    }

    public RadarAxis getAxis() {
        return this.axis;
    }

    public void setAxisIndicators(CategoryDataProvider axisIndicators) {
        this.axisIndicators = axisIndicators;
    }

    public CategoryDataProvider getAxisIndicators() {
        return this.axisIndicators;
    }

    @Override
    public void validate() throws ChartException {
        if (this.axisIndicators == null || this.axisIndicators.stream().findAny().isEmpty()) {
            throw new ChartException("No axis-indicators for " + this.className());
        }
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        ComponentPart.addComma(sb);
        sb.append("\"indicator\":[");
        AtomicBoolean first = new AtomicBoolean(true);
        this.axisIndicators.stream().forEach(category -> {
            if (first.get()) {
                first.set(false);
            } else {
                sb.append(',');
            }
            sb.append("{\"name\":").append(ComponentPart.escape(category)).append('}');
        });
        sb.append(']');
        ComponentPart.encode(sb, "startAngle", this.startingAngle);
        if (this.circular) {
            ComponentPart.encode(sb, "shape", "circle");
        }
        ComponentPart.encode(sb, null, this.color);
    }

    @Override
    public final PolarProperty getPolarProperty(boolean create) {
        if (this.polarProperty == null && create) {
            this.polarProperty = new PolarProperty();
        }
        return this.polarProperty;
    }

    @Override
    public final void setPolarProperty(PolarProperty polarProperty) {
        this.polarProperty = polarProperty;
    }

    public int getStartingAngle() {
        return this.startingAngle;
    }

    public void setStartingAngle(int startingAngle) {
        this.startingAngle = startingAngle;
    }

    public final AbstractColor getColor() {
        return this.color;
    }

    public void setColor(AbstractColor color) {
        this.color = color;
    }

    public void setCircular(boolean circular) {
        this.circular = circular;
    }

    public final boolean isCircular() {
        return this.circular;
    }
}

