/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.AbstractProject;
import com.storedobject.chart.AbstractTask;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.Color;
import com.storedobject.chart.DataType;
import com.storedobject.chart.SOChart;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class Project
extends AbstractProject {
    private final List<TaskGroup> taskGroups = new ArrayList<TaskGroup>();
    private boolean checked = false;

    public Project() {
        this(null);
    }

    public Project(ChronoUnit durationType) {
        super(durationType);
    }

    @Override
    void validateConstraints() throws ChartException {
        if (this.checked) {
            return;
        }
        super.validateConstraints();
        this.taskGroups.removeIf(tg -> tg.tasks.isEmpty());
        for (TaskGroup taskGroup : this.taskGroups) {
            Project.validateDependency(taskGroup);
            for (Task task : taskGroup.tasks) {
                Project.validateDependency(task);
            }
        }
        this.schedule();
        this.taskGroups.sort(Project::compare);
        this.taskGroups.forEach(TaskGroup::sort);
        this.checked = true;
    }

    @Override
    public boolean isEmpty() {
        return this.taskGroups.isEmpty();
    }

    private void schedule() {
        LocalDateTime start = this.getStart();
        for (TaskGroup taskGroup : this.taskGroups) {
            taskGroup.start = start;
            taskGroup.tasks.forEach(t -> {
                t.start = start;
            });
        }
        this.adjustTaskStart();
        this.adjustGroupStart();
        this.adjustStart();
        while (this.adjustTaskStart() && (this.adjustGroupStart() || this.adjustStart())) {
        }
    }

    private boolean adjustTaskStart() {
        boolean adjusted = false;
        for (TaskGroup taskGroup : this.taskGroups) {
            for (Task task : taskGroup.tasks) {
                if (!task.applyTaskStartDependency()) continue;
                adjusted = true;
            }
        }
        return adjusted;
    }

    private boolean adjustGroupStart() {
        boolean adjusted = false;
        for (TaskGroup taskGroup : this.taskGroups) {
            if (!taskGroup.applyGroupStartDependency()) continue;
            adjusted = true;
        }
        return adjusted;
    }

    private boolean adjustStart() {
        boolean adjusted = false;
        for (TaskGroup taskGroup : this.taskGroups) {
            if (taskGroup.applyStartDependency()) {
                adjusted = true;
            }
            for (Task task : taskGroup.tasks) {
                if (!task.applyStartDependency()) continue;
                adjusted = true;
            }
        }
        return adjusted;
    }

    private static void validateDependency(ProjectTask instance) throws ChartException {
        if (Project.validateDependency(instance, instance.predecessors)) {
            throw new ChartException("Circular dependency: Task " + (instance instanceof TaskGroup ? "Group " : "") + "'" + instance.getName() + "'");
        }
    }

    private static boolean validateDependency(ProjectTask instance, List<ProjectTask> predecessors) {
        if (predecessors.contains(instance)) {
            return true;
        }
        for (ProjectTask a : predecessors) {
            if (a instanceof TaskGroup) {
                Task t;
                TaskGroup tg = (TaskGroup)a;
                if (instance instanceof Task && tg.tasks.contains(t = (Task)instance)) {
                    return true;
                }
            }
            if (a instanceof Task) {
                TaskGroup tg;
                Task t = (Task)a;
                if (instance instanceof TaskGroup && (tg = (TaskGroup)instance).equals(t.group)) {
                    return true;
                }
            }
            if (!Project.validateDependency(instance, a.predecessors)) continue;
            return true;
        }
        return false;
    }

    public TaskGroup createTaskGroup(String name) {
        TaskGroup taskGroup = new TaskGroup(name);
        this.taskGroups.addFirst(taskGroup);
        return taskGroup;
    }

    public Task createTask(String name, int duration) {
        return this.createTask(this.createTaskGroup("DEFAULT"), name, duration);
    }

    public Task createTask(TaskGroup taskGroup, String taskName, int duration) {
        if (this.taskGroups.contains(taskGroup)) {
            return new Task(this, taskGroup, taskName, duration);
        }
        return null;
    }

    private void deleteTask(Task task) {
        if (task == null) {
            return;
        }
        this.checked = false;
        task.group.tasks.remove(task);
        this.taskGroups.forEach(taskGroup -> taskGroup.tasks.forEach(t -> t.predecessors.remove(task)));
    }

    private void deleteGroup(TaskGroup taskGroup) {
        if (taskGroup == null) {
            return;
        }
        this.checked = false;
        this.taskGroups.remove(taskGroup);
        while (!taskGroup.tasks.isEmpty()) {
            this.deleteTask(taskGroup.tasks.getFirst());
        }
    }

    public void delete(TaskGroup ... taskGroups) {
        if (taskGroups != null) {
            for (TaskGroup taskGroup : taskGroups) {
                this.deleteGroup(taskGroup);
            }
        }
    }

    public void delete(Task ... tasks) {
        if (tasks != null) {
            for (Task task : tasks) {
                this.deleteTask(task);
            }
        }
    }

    public void dependsOn(ProjectTask dependent, ProjectTask predecessor) {
        if (dependent == null || predecessor == null) {
            return;
        }
        List<ProjectTask> predecessors = dependent.predecessors;
        if (!predecessors.contains(predecessor)) {
            predecessors.add(predecessor);
        }
    }

    @Override
    public final void setStart(LocalDateTime start) {
        this.checked = false;
        super.setStart(start);
    }

    @Override
    public final LocalDateTime getEnd() {
        LocalDateTime start;
        LocalDateTime end = start = this.getStart();
        for (TaskGroup taskGroup : this.taskGroups) {
            for (Task task : taskGroup.tasks) {
                LocalDateTime e = task.getEnd();
                if (!e.isAfter(end)) continue;
                end = e;
            }
        }
        return end;
    }

    public void resetEarliestStart(ProjectTask task) {
        this.checked = false;
        task.earliestStart = null;
    }

    public void setEarliestStart(ProjectTask task, LocalDateTime start) {
        this.checked = false;
        task.earliestStart = this.trim(start);
    }

    public void setEarliestStart(ProjectTask task, LocalDate start) {
        this.setEarliestStart(task, start.atStartOfDay());
    }

    public void setEarliestStart(ProjectTask task, Instant start) {
        this.setEarliestStart(task, LocalDateTime.from(start));
    }

    private static int compare(ProjectTask a1, ProjectTask a2) {
        int c = a2.getStart().compareTo(a1.getStart());
        return c == 0 ? Integer.compare(a1.order, a2.order) : c;
    }

    @Override
    public final int getRowCount() {
        return this.taskGroups.stream().mapToInt(tg -> tg.tasks.size()).sum();
    }

    public final TaskGroup getTaskGroup(int groupIndex) {
        return this.taskGroups.get(groupIndex);
    }

    public final int getGroupCount() {
        return this.taskGroups.size();
    }

    @Override
    boolean isEmptyGroup() {
        return this.taskGroups.isEmpty();
    }

    public Stream<TaskGroup> streamGroups() {
        try {
            this.validateConstraints();
        }
        catch (ChartException e) {
            return null;
        }
        return this.taskGroups.stream();
    }

    public Stream<Task> streamTasks(TaskGroup taskGroup) {
        try {
            this.validateConstraints();
        }
        catch (ChartException e) {
            return null;
        }
        return taskGroup.tasks.stream();
    }

    public Stream<ProjectTask> streamDependencies(ProjectTask task) {
        try {
            this.validateConstraints();
        }
        catch (ChartException e) {
            return null;
        }
        return task.predecessors.stream();
    }

    @Override
    public <T> Iterator<T> iterator(BiFunction<AbstractTask, Integer, T> function, Predicate<AbstractTask> taskFilter) {
        return new TaskIterator<T>(function, taskFilter);
    }

    @Override
    protected AbstractDataProvider<String> dependencies() {
        BiFunction<AbstractTask, Integer, String> func = (t, i) -> "[" + i + "," + this.encode(t.renderStart()) + "," + this.encode(t.getEnd()) + "," + this.dependents((Task)t) + "]";
        return this.dataProvider(DataType.OBJECT, func, t -> !((Task)t).predecessors.isEmpty());
    }

    private String dependents(Task task) {
        StringBuilder sb = new StringBuilder("{\"d\":[");
        boolean first = true;
        for (ProjectTask at : task.predecessors) {
            if (at instanceof TaskGroup) {
                TaskGroup tg = (TaskGroup)at;
                at = tg.tasks.getLast();
            }
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append("[").append(this.indexOf((Task)at)).append(",").append(this.encode(at.renderStart())).append(",").append(this.encode(at.getEnd())).append("]");
        }
        sb.append("]}");
        return "\"" + sb.toString().replace("\"", "^") + "\"";
    }

    private int indexOf(Task t) {
        int n = 0;
        for (TaskGroup tg : this.taskGroups) {
            if (tg == t.group) break;
            n += tg.tasks.size();
        }
        return n + t.group.tasks.indexOf(t);
    }

    @Override
    protected String getExtraAxisLabel(AbstractTask task) {
        Object timeName;
        long left;
        if (task.isCompleted()) {
            return task.isMilestone() ? "Achieved" : "Completed";
        }
        LocalDateTime today = this.getToday();
        ChronoUnit durationType = this.getDurationType();
        Duration duration = Duration.between(task.getEnd(), today);
        if (durationType.isDateBased()) {
            left = duration.toDays();
            timeName = "day";
        } else {
            switch (durationType) {
                case SECONDS: {
                    left = duration.toSeconds();
                    timeName = "second";
                    break;
                }
                case MINUTES: {
                    left = duration.toMinutes();
                    timeName = "minute";
                    break;
                }
                case HOURS: {
                    left = duration.toHours();
                    timeName = "hour";
                    break;
                }
                default: {
                    left = duration.toMillis();
                    timeName = "millisecond";
                }
            }
        }
        if (Math.abs(left) != 1L) {
            timeName = (String)timeName + "s";
        }
        if (left > 0L) {
            return "Late by " + left + " " + (String)timeName;
        }
        return -left + " " + (String)timeName + " remaining";
    }

    @Override
    final String getAxisLabel(AbstractTask abstractTask, int index) {
        Task task = (Task)abstractTask;
        return "[" + index + ",\"" + this.getAxisLabel(task.group) + "\"," + (task == task.group.tasks.getLast() ? 0 : 1) + ",\"" + this.getAxisLabel(task) + "\",\"" + this.getExtraAxisLabel(task) + "\"," + String.valueOf(task.getColor()) + "," + this.groupFontSize(task) + "," + this.extraFontSize(task) + "]";
    }

    @Override
    AbstractDataProvider<String> axisLabels() {
        return this.dataProvider(DataType.OBJECT, this::getAxisLabel);
    }

    public class TaskGroup
    extends ProjectTask {
        private final List<Task> tasks;

        TaskGroup(String name) {
            super(name);
            this.tasks = new ArrayList<Task>();
        }

        public Task createTask(String name, int duration) {
            return Project.this.createTask(this, name, duration);
        }

        @Override
        public Color getColor() {
            Color color = super.getColor();
            if (color == null) {
                color = SOChart.getDefaultColor(Project.this.taskGroups.indexOf(this));
                this.setColor(color);
            }
            return color;
        }

        private void sort() {
            this.tasks.sort(Project::compare);
        }

        @Override
        public final int getDuration() {
            LocalDateTime start = null;
            LocalDateTime end = null;
            for (Task task : this.tasks) {
                LocalDateTime taskStart = task.getStart();
                if (start == null || taskStart.isBefore(start)) {
                    start = taskStart;
                }
                LocalDateTime taskEnd = task.getEnd();
                if (end != null && !taskEnd.isAfter(end)) continue;
                end = taskEnd;
            }
            if (start == null) {
                return 0;
            }
            return (int)Project.this.getDurationType().between(start, end);
        }

        @Override
        public final LocalDateTime getStart() {
            LocalDateTime taskStart = this.tasks.getFirst().getStart();
            if (taskStart.isBefore(this.start)) {
                this.start = taskStart;
            }
            for (Task task : this.tasks) {
                taskStart = task.getStart();
                if (!taskStart.isBefore(this.start)) continue;
                this.start = taskStart;
            }
            return super.getStart();
        }

        public final Task getTask(int taskIndex) {
            return this.tasks.get(taskIndex);
        }

        public final int getTaskCount() {
            return this.tasks.size();
        }

        @Override
        public boolean isCompleted() {
            return this.tasks.stream().allMatch(AbstractTask::isCompleted);
        }

        @Override
        public double getCompleted() {
            return 0.0;
        }
    }

    public abstract class ProjectTask
    extends AbstractTask {
        private int order = -1;
        LocalDateTime earliestStart = null;
        final List<ProjectTask> predecessors = new ArrayList<ProjectTask>();

        protected ProjectTask(String name) {
            this.setName(name);
        }

        @Override
        public final String getName() {
            String name = super.getName();
            if (name != null && !name.isEmpty()) {
                return "DEFAULT".equals(name) ? "" : name;
            }
            return (this instanceof Task ? "Task" : "Group") + ": " + this.getId();
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }

        @Override
        public abstract int getDuration();

        @Override
        public LocalDateTime getStart() {
            this.start = AbstractProject.max(this.earliestStart, this.start);
            return this.start;
        }

        @Override
        public final LocalDateTime getEnd() {
            return this.getStart().plus(this.getDuration(), Project.this.getDurationType());
        }

        boolean applyTaskStartDependency() {
            return this.applyStartDependency(a -> a instanceof TaskGroup);
        }

        boolean applyGroupStartDependency() {
            return this.applyStartDependency(a -> a instanceof Task);
        }

        boolean applyStartDependency() {
            return this.applyStartDependency(a -> false);
        }

        private boolean applyStartDependency(Predicate<ProjectTask> skip) {
            if (this.predecessors.isEmpty()) {
                return false;
            }
            for (ProjectTask p : this.predecessors) {
                if (skip.test(p)) continue;
                p.applyStartDependency(skip);
            }
            boolean adjusted = false;
            for (ProjectTask p : this.predecessors) {
                Task task;
                if (skip.test(p)) continue;
                LocalDateTime end = p.getEnd();
                if (!(p instanceof Task) || !(task = (Task)p).isMilestone()) {
                    end = end.plus(1L, Project.this.getDurationType());
                }
                if (!this.start.isBefore(end)) continue;
                adjusted = true;
                this.start = end;
            }
            return adjusted;
        }

        @Override
        public LocalDateTime renderStart() {
            if (this.getDuration() == 0) {
                return this.start.minus(1L, Project.this.getDurationType());
            }
            return this.start;
        }
    }

    public class Task
    extends ProjectTask {
        private final int duration;
        private final TaskGroup group;
        private double completed = 0.0;

        Task(Project this$0, TaskGroup taskGroup, String name, int duration) {
            super(name);
            this.group = taskGroup;
            this.group.tasks.add(this);
            this.duration = Math.max(duration, 0);
        }

        public void setCompleted(double completed) {
            this.completed = Math.min(Math.max(0.0, completed), 100.0);
        }

        @Override
        public final double getCompleted() {
            return this.completed;
        }

        @Override
        public final int getDuration() {
            return this.duration;
        }

        @Override
        public final boolean isMilestone() {
            return this.duration == 0;
        }

        @Override
        public LocalDateTime getStart() {
            this.start = AbstractProject.max(this.start, this.group.earliestStart);
            return super.getStart();
        }

        public final TaskGroup getGroup() {
            return this.group;
        }

        @Override
        public boolean isCompleted() {
            if (this.duration > 0) {
                return this.completed >= 100.0;
            }
            return this.predecessors.stream().allMatch(AbstractTask::isCompleted);
        }

        @Override
        public Color getColor() {
            Color color = super.getColor();
            return color == null ? this.group.getColor() : color;
        }
    }

    private class TaskIterator<T>
    extends AbstractProject.ElementIterator<T> {
        private TaskIterator(BiFunction<AbstractTask, Integer, T> encoder, Predicate<AbstractTask> taskFilter) {
            super(encoder, taskFilter);
        }

        @Override
        void checkNext() {
            TaskGroup taskGroup = Project.this.taskGroups.get(this.groupIndex);
            while (this.taskIndex >= taskGroup.tasks.size()) {
                if (++this.groupIndex >= Project.this.taskGroups.size()) {
                    this.groupIndex = Integer.MIN_VALUE;
                    this.next = null;
                    return;
                }
                taskGroup = Project.this.taskGroups.get(this.groupIndex);
                if (taskGroup.tasks.isEmpty()) continue;
                this.taskIndex = 0;
                break;
            }
            ++this.index;
            this.next = taskGroup.getTask(this.taskIndex);
        }
    }
}

