/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.Axis;
import com.storedobject.chart.BasicInternalDataProvider;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.ComponentProperty;
import com.storedobject.chart.HasData;
import com.storedobject.chart.ItemStyle;
import com.storedobject.chart.XAxis;
import com.storedobject.chart.YAxis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public class MarkArea
implements ComponentProperty,
HasData {
    private ItemStyle itemStyle;
    private final List<Block> blocks = new ArrayList<Block>();
    final AbstractDataProvider<?> data = new Data();

    @Override
    public void declareData(Set<AbstractDataProvider<?>> dataSet) {
        dataSet.add(this.data);
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        ComponentPart.encode(sb, "itemStyle", this.itemStyle);
        ComponentPart.encode(sb, "data", this.data.getSerial());
    }

    public final ItemStyle getItemStyle(boolean create) {
        if (this.itemStyle == null && create) {
            this.itemStyle = new ItemStyle();
        }
        return this.itemStyle;
    }

    public void setItemStyle(ItemStyle itemStyle) {
        this.itemStyle = itemStyle;
    }

    public void add(Block ... blocks) {
        if (blocks != null) {
            Collections.addAll(this.blocks, blocks);
        }
    }

    public void remove(Block ... blocks) {
        if (blocks != null) {
            for (Block block : blocks) {
                this.blocks.remove(block);
            }
        }
    }

    public void clear() {
        this.blocks.clear();
    }

    private class Data
    extends BasicInternalDataProvider<Object> {
        private Data() {
        }

        @Override
        public Stream<Object> stream() {
            return MarkArea.this.blocks.stream().map(o -> o);
        }

        @Override
        public void encode(StringBuilder sb, Object value) {
            ((Block)value).encodeJSON(sb);
        }
    }

    public static class Block
    implements ComponentProperty {
        private String name;
        private ItemStyle itemStyle;
        private Axis axis1;
        private Axis axis2;
        private final Side start = new Side();
        private final Side end = new Side();

        @Override
        public void encodeJSON(StringBuilder sb) {
            sb.append("[{");
            ComponentPart.encode(sb, "name", this.name);
            ComponentPart.encode(sb, "itemStyle", this.itemStyle);
            this.start.encodeJSON(sb);
            sb.append("},{");
            this.end.encodeJSON(sb);
            sb.append("}]");
        }

        public final String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public final Side getStartingSide() {
            return this.start;
        }

        public final Side getEndingSide() {
            return this.end;
        }

        public void setSides(Axis axis, Object valueFrom, Object valueTo) {
            this.sides(axis, null, valueFrom, null, valueTo, null);
        }

        public void setSides(XAxis xAxis, YAxis yAxis, Object xValueFrom, Object yValueFrom, Object xValueTo, Object yValueTo) {
            this.sides(xAxis, yAxis, xValueFrom, yValueFrom, xValueTo, yValueTo);
        }

        private void sides(Axis xAxis, Axis yAxis, Object xValueFrom, Object yValueFrom, Object xValueTo, Object yValueTo) {
            this.axis1 = xAxis;
            this.start.value1 = xValueFrom;
            this.axis2 = yAxis;
            this.start.value2 = yValueFrom;
            this.end.value1 = xValueTo;
            this.end.value2 = yValueTo;
        }

        public final ItemStyle getItemStyle(boolean create) {
            if (this.itemStyle == null && create) {
                this.itemStyle = new ItemStyle();
            }
            return this.itemStyle;
        }

        public void setItemStyle(ItemStyle itemStyle) {
            this.itemStyle = itemStyle;
        }

        public class Side
        implements ComponentProperty {
            private Object value1;
            private Object value2;

            @Override
            public void encodeJSON(StringBuilder sb) {
                if (Block.this.axis1 != null) {
                    ComponentPart.encode(sb, Block.this.axis1.axisName(), this.value1);
                }
                if (Block.this.axis2 != null) {
                    ComponentPart.encode(sb, Block.this.axis2.axisName(), this.value2);
                }
            }

            public void setValue(Object value) {
                this.setValue(value, null);
            }

            public void setValue(Object valueX, Object valueY) {
                this.value1 = valueX;
                this.value2 = valueY;
            }
        }
    }
}

