/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.AreaStyle;
import com.storedobject.chart.ChartType;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.LineStyle;
import com.storedobject.chart.Location;
import com.storedobject.chart.PointSymbol;
import com.storedobject.chart.XYChart;

public class LineChart
extends XYChart {
    private Object smoothness;
    private Object stepped;
    private boolean connectNulls;
    private PointSymbol pointSymbol;

    public LineChart() {
        this((AbstractDataProvider<?>)null, (AbstractDataProvider<?>)null);
    }

    public LineChart(AbstractDataProvider<?> xData, AbstractDataProvider<?> yData) {
        super(ChartType.Line, xData, yData);
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        if (this.smoothness != null) {
            sb.append(",\"smooth\":");
            if (this.smoothness instanceof Number) {
                sb.append((double)((Number)this.smoothness).intValue() / 100.0);
            } else {
                sb.append(this.smoothness);
            }
            this.smoothness = null;
        }
        if (this.stepped != null) {
            sb.append(",\"step\":").append(this.stepped);
            this.stepped = null;
        }
        if (this.pointSymbol != null) {
            this.pointSymbol.encodeJSON(sb);
        }
        ComponentPart.encode(sb, "connectNulls", this.connectNulls);
    }

    public void setSmoothness(boolean smoothness) {
        this.smoothness = smoothness;
    }

    public void setSmoothness(int percentage) {
        percentage = Math.max(0, Math.min(percentage, 100));
        this.smoothness = percentage;
    }

    public void setStepped(boolean stepped) {
        this.stepped = stepped;
    }

    public void setStepped(Location location) {
        this.stepped = location == null ? null : Location.h(location);
    }

    public void setConnectNullPoints(boolean connectNullPoints) {
        this.connectNulls = connectNullPoints;
    }

    public LineStyle getLineStyle(boolean create) {
        return this.getProperty(LineStyle.class, create);
    }

    public void setLineStyle(LineStyle lineStyle) {
        this.setProperty(lineStyle);
    }

    public AreaStyle getAreaStyle(boolean create) {
        return this.getProperty(AreaStyle.class, create);
    }

    public void setAreaStyle(AreaStyle areaStyle) {
        this.setProperty(areaStyle);
    }

    public PointSymbol getPointSymbol(boolean create) {
        if (this.pointSymbol == null && create) {
            this.pointSymbol = new PointSymbol();
        }
        return this.pointSymbol;
    }

    public void setPointSymbol(PointSymbol pointSymbol) {
        this.pointSymbol = pointSymbol;
    }
}

