/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.Border;
import com.storedobject.chart.Chart;
import com.storedobject.chart.Component;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.HasPadding;
import com.storedobject.chart.HasPosition;
import com.storedobject.chart.Padding;
import com.storedobject.chart.Position;
import com.storedobject.chart.TextStyle;
import com.storedobject.chart.VisiblePart;
import java.util.ArrayList;
import java.util.List;

public class Legend
extends VisiblePart
implements Component,
HasPosition,
HasPadding {
    private Position position;
    private Padding padding;
    private TextStyle textStyle;
    private boolean vertical = false;
    private Border border;
    private List<Chart> hiddenCharts;

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        ComponentPart.encode(sb, "textStyle", this.textStyle);
        if (this.vertical) {
            ComponentPart.encode(sb, "orient", "vertical");
        }
        ComponentPart.encode(sb, null, this.border);
        if (this.hiddenCharts != null && !this.hiddenCharts.isEmpty()) {
            ComponentPart.addComma(sb);
            sb.append("\"selected\":{");
            for (int i = 0; i < this.hiddenCharts.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(ComponentPart.escape(this.hiddenCharts.get(i).getName())).append(":false");
            }
            sb.append('}');
        }
    }

    @Override
    public void validate() {
    }

    public void showVertically() {
        this.vertical = true;
    }

    @Override
    public final Position getPosition(boolean create) {
        if (this.position == null && create) {
            this.position = new Position();
        }
        return this.position;
    }

    @Override
    public final void setPosition(Position position) {
        this.position = position;
    }

    public final TextStyle getTextStyle(boolean create) {
        if (this.textStyle == null && create) {
            this.textStyle = new TextStyle();
        }
        return this.textStyle;
    }

    public void setTextStyle(TextStyle textStyle) {
        this.textStyle = textStyle;
    }

    @Override
    public Padding getPadding(boolean create) {
        if (this.padding == null && create) {
            this.padding = new Padding();
        }
        return this.padding;
    }

    @Override
    public void setPadding(Padding padding) {
        this.padding = padding;
    }

    public final Border getBorder(boolean create) {
        if (this.border == null && create) {
            this.border = new Border();
        }
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    private List<Chart> hiddenCharts() {
        if (this.hiddenCharts == null) {
            this.hiddenCharts = new ArrayList<Chart>();
        }
        return this.hiddenCharts;
    }

    public void hide(Chart chart) {
        if (chart != null) {
            this.hiddenCharts().add(chart);
        }
    }

    public void show(Chart chart) {
        if (chart != null) {
            this.hiddenCharts().remove(chart);
        }
    }
}

