/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.ChartType;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.DataProvider;
import com.storedobject.chart.SelfPositioningChart;
import com.storedobject.chart.Size;

public class FunnelChart
extends SelfPositioningChart {
    private int tailSize = 0;
    private int mouthSize = -100;
    private int sliceGap = 0;
    private byte align = 0;
    private boolean inverted = false;
    private boolean sorted = true;

    public FunnelChart() {
        this((AbstractDataProvider<?>)null, (DataProvider)null);
    }

    public FunnelChart(AbstractDataProvider<?> itemNames, DataProvider values) {
        super(ChartType.Funnel, itemNames, values);
    }

    public void setItemNames(AbstractDataProvider<?> itemNames) {
        this.setData(itemNames, 0);
    }

    public void setData(DataProvider data) {
        this.setData(data, 1);
    }

    public void setTailSize(Size size) {
        this.tailSize = size.get();
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        if (this.mouthSize != -100) {
            sb.append(',');
            sb.append("\"maxSize\":").append(Size.code(this.mouthSize));
        }
        if (this.tailSize != 0) {
            sb.append(',');
            sb.append("\"minSize\":").append(Size.code(this.tailSize));
        }
        if (!this.sorted || this.inverted) {
            sb.append(",\"sort\":\"").append(!this.sorted ? "none" : "ascending").append('\"');
        }
        if (this.sliceGap > 0) {
            sb.append(',');
            ComponentPart.encode(sb, "gap", this.sliceGap);
        }
        if (this.align != 0) {
            sb.append(",\"funnelAlign\":\"").append(this.align < 0 ? "left" : "right").append('\"');
        }
    }

    public int getSliceGap() {
        return this.sliceGap;
    }

    public void setSliceGap(int sliceGap) {
        this.sliceGap = sliceGap;
    }

    public void setMouthSize(Size mouthSize) {
        this.mouthSize = mouthSize.get();
    }

    public void fitOnLeftSide() {
        this.align = (byte)-1;
    }

    public void fitOnRightSide() {
        this.align = 1;
    }

    public void showAtCenter() {
        this.align = 0;
    }
}

