/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.DataType;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class FunctionData
implements AbstractDataProvider<Double> {
    private int serial = -1;
    private String name;
    private final Supplier<Stream<?>> streamSupplier = streamSupplier::get;
    private final ToDoubleFunction<?> converter;

    private <T> FunctionData(Supplier<Stream<T>> streamSupplier, ToDoubleFunction<T> converter) {
        this.converter = converter;
    }

    public static <T> FunctionData create(AbstractDataProvider<T> xValues, ToDoubleFunction<T> converter) {
        return new FunctionData(xValues::stream, converter);
    }

    public static <T> FunctionData create(Supplier<Stream<T>> streamSupplier, ToDoubleFunction<T> converter) {
        return new FunctionData(streamSupplier, converter);
    }

    public static FunctionData create(int startingValue, int endingValue) {
        return FunctionData.create(startingValue, endingValue, startingValue < endingValue ? 1 : -1);
    }

    public static FunctionData create(int startingValue, int endingValue, int step) {
        return FunctionData.create((int i) -> i, startingValue, endingValue, step);
    }

    public static FunctionData create(IntToDoubleFunction converter, int startingValue, int endingValue) {
        return FunctionData.create(converter, startingValue, endingValue, startingValue < endingValue ? 1 : -1);
    }

    public static FunctionData create(IntToDoubleFunction converter, int startingValue, int endingValue, int step) {
        IntPredicate hasNext = step < 0 ? i -> i > endingValue : i -> i < endingValue;
        return new FunctionData(() -> IntStream.iterate(startingValue, hasNext, i -> i + step).boxed(), converter::applyAsDouble);
    }

    public static FunctionData create(double startingValue, double endingValue, double step) {
        return FunctionData.create((double d) -> d, startingValue, endingValue, step);
    }

    public static FunctionData create(DoubleFunction<Double> converter, double startingValue, double endingValue) {
        return FunctionData.create(converter, startingValue, endingValue, startingValue < endingValue ? 1.0 : -1.0);
    }

    public static FunctionData create(DoubleFunction<Double> converter, double startingValue, double endingValue, double step) {
        DoublePredicate hasNext = step < 0.0 ? d -> d > endingValue : d -> d < endingValue;
        return new FunctionData(() -> DoubleStream.iterate(startingValue, hasNext, d -> d + step).boxed(), converter::apply);
    }

    @Override
    public final Stream<Double> stream() {
        return new Streamer(this.streamSupplier.get(), this.converter).streamIt();
    }

    @Override
    public final DataType getDataType() {
        return DataType.NUMBER;
    }

    @Override
    public final int getSerial() {
        return this.serial;
    }

    @Override
    public final void setSerial(int serial) {
        this.serial = serial;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private record Streamer<T>(Stream<T> stream, ToDoubleFunction<T> converter) {
        private Stream<Double> streamIt() {
            return this.stream.map(this.converter::applyAsDouble);
        }
    }
}

