/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

public class Font {
    private Style style;
    private Weight weight;
    private Variant variant;
    private Size size;
    private Size lineHeight;
    private Family family;
    private Stretch stretch;

    public Font(Family family, Size size) {
        this(family, null, size);
    }

    public Font(Family family, Style style, Size size) {
        this.setFamily(family);
        this.style = style;
        this.setSize(size);
    }

    public final Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public final Size getSize() {
        return this.size;
    }

    public final void setSize(Size size) {
        this.size = size == null ? Size.medium() : size;
    }

    public final Size getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(Size size) {
        this.lineHeight = size;
    }

    public final Weight getWeight() {
        return this.weight;
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public final Variant getVariant() {
        return this.variant;
    }

    public void setVariant(Variant variant) {
        this.variant = variant;
    }

    public final Family getFamily() {
        return this.family;
    }

    public final void setFamily(Family family) {
        this.family = family == null ? Family.sans_serif() : family;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\"");
        if (this.style != null) {
            sb.append((Object)this.style);
        }
        if (this.variant != null) {
            sb.append(' ').append((Object)this.variant);
        }
        if (this.weight != null) {
            sb.append(' ').append(this.weight);
        }
        sb.append(' ').append(this.size);
        if (this.lineHeight != null) {
            sb.append('/').append(this.lineHeight);
        }
        sb.append(' ').append(this.family).append('\"');
        return sb.charAt(0) == ' ' ? sb.substring(1) : sb.toString();
    }

    public static class Family {
        final String family;
        final int type;
        Family fallback;

        private Family(String family, int type) {
            this.family = family;
            this.type = type;
        }

        private Family(int type) {
            this(null, type);
        }

        public static Family create(String familyName) {
            return new Family(familyName, 0);
        }

        public static Family serif() {
            return new Family(1);
        }

        public static Family sans_serif() {
            return new Family(2);
        }

        public static Family monospace() {
            return new Family(3);
        }

        public static Family cursive() {
            return new Family(4);
        }

        public static Family fantasy() {
            return new Family(5);
        }

        public static Family system_ui() {
            return new Family(6);
        }

        public static Family ui_serif() {
            return new Family(7);
        }

        public static Family ui_sans_serif() {
            return new Family(8);
        }

        public static Family ui_monospace() {
            return new Family(9);
        }

        public static Family ui_rounded() {
            return new Family(10);
        }

        public static Family math() {
            return new Family(11);
        }

        public static Family emoji() {
            return new Family(12);
        }

        public static Family fangsong() {
            return new Family(13);
        }

        public void addFallback(Family fallbackFamily) {
            if (this.fallback == null) {
                this.fallback = fallbackFamily;
            } else {
                this.fallback.addFallback(fallbackFamily);
            }
        }

        public String toString() {
            String s = switch (this.type) {
                case 1 -> "serif";
                case 2 -> "sans-serif";
                case 3 -> "monospace";
                case 4 -> "cursive";
                case 5 -> "fantasy";
                case 6 -> "system-ui";
                case 7 -> "ui-serif";
                case 8 -> "ui-sans-serif";
                case 9 -> "ui-monospace";
                case 10 -> "math";
                case 11 -> "emoji";
                case 12 -> "fangsong";
                default -> "'" + this.family + "'";
            };
            return this.plus(s);
        }

        private String plus(String s) {
            if (this.fallback == null) {
                return s;
            }
            return s + "," + String.valueOf(this.fallback);
        }
    }

    public static enum Style {
        NORMAL,
        ITALIC,
        OBLIQUE;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static class Size {
        private final int size;
        private final int type;

        private Size(int size, int type) {
            this.size = size;
            this.type = type;
        }

        private Size(double size, int type) {
            this((int)(size * 1000.0), type);
        }

        public static Size percentage(double percentage) {
            return new Size(percentage, 1);
        }

        public static Size pixels(double pixels) {
            return new Size(pixels, 2);
        }

        public static Size points(double points) {
            return new Size(points, 3);
        }

        public static Size em(double em) {
            return new Size(em, 4);
        }

        public static Size rem(double rem) {
            return new Size(rem, 5);
        }

        public static Size number(int number) {
            return new Size(number, 6);
        }

        public static Size medium() {
            return new Size(3, 0);
        }

        public static Size large() {
            return new Size(4, 0);
        }

        public static Size larger() {
            return new Size(9, 0);
        }

        public static Size x_large() {
            return new Size(5, 0);
        }

        public static Size xx_large() {
            return new Size(6, 0);
        }

        public static Size xxx_large() {
            return new Size(7, 0);
        }

        public static Size small() {
            return new Size(2, 0);
        }

        public static Size smaller() {
            return new Size(8, 0);
        }

        public static Size x_small() {
            return new Size(1, 0);
        }

        public static Size xx_small() {
            return new Size(0, 0);
        }

        public String toString() {
            if (this.type == 0) {
                switch (this.size) {
                    case 0: {
                        return "xx-small";
                    }
                    case 1: {
                        return "x-small";
                    }
                    case 2: {
                        return "small";
                    }
                    case 3: {
                        return "medium";
                    }
                    case 4: {
                        return "large";
                    }
                    case 5: {
                        return "x-large";
                    }
                    case 6: {
                        return "xx-large";
                    }
                    case 7: {
                        return "xxx-large";
                    }
                    case 8: {
                        return "smaller";
                    }
                    case 9: {
                        return "larger";
                    }
                }
            }
            String suffix = "";
            switch (this.type) {
                case 1: {
                    suffix = "%";
                    break;
                }
                case 2: {
                    suffix = "px";
                    break;
                }
                case 3: {
                    suffix = "pt";
                    break;
                }
                case 4: {
                    suffix = "em";
                    break;
                }
                case 5: {
                    suffix = "rem";
                    break;
                }
                case 6: {
                    return String.valueOf(this.size);
                }
            }
            Object s = String.valueOf(this.size / 1000);
            int r = this.size % 1000;
            if (r > 0) {
                s = r < 10 ? (String)s + ".00" + r : (r < 100 ? (String)s + ".0" + r : (String)s + "." + r);
            }
            return (String)s + suffix;
        }
    }

    public static class Weight {
        public static final Weight NORMAL = new Weight(0);
        public static final Weight BOLD = new Weight(-1);
        public static final Weight BOLDER = new Weight(-2);
        public static final Weight LIGHTER = new Weight(-3);
        private final int weight;

        public Weight(int weight) {
            if (weight < 100 && weight > 0) {
                weight *= 100;
            }
            this.weight = weight;
        }

        public String toString() {
            if (this.weight <= 0) {
                return switch (this.weight) {
                    case -3 -> "lighter";
                    case -2 -> "bolder";
                    case -1 -> "bold";
                    default -> "normal";
                };
            }
            return String.valueOf(this.weight);
        }
    }

    public static enum Variant {
        NORMAL,
        SMALL_CAPS;


        public String toString() {
            return super.toString().toLowerCase().replace('_', '-');
        }
    }

    public static class Stretch {
        final int value;

        private Stretch(int value) {
            this.value = value;
        }

        private Stretch(double value) {
            this((int)(value * 1000.0));
        }

        public static Stretch create(double percentageToStretch) {
            return new Stretch(percentageToStretch);
        }

        public static Stretch ultra_condensed() {
            return new Stretch(50000);
        }

        public static Stretch normal() {
            return new Stretch(100000);
        }

        public static Stretch extra_condensed() {
            return new Stretch(62500);
        }

        public static Stretch condensed() {
            return new Stretch(75000);
        }

        public static Stretch semi_condensed() {
            return new Stretch(87500);
        }

        public static Stretch expanded() {
            return new Stretch(125000);
        }

        public static Stretch semi_expanded() {
            return new Stretch(112500);
        }

        public static Stretch extra_expanded() {
            return new Stretch(150000);
        }

        public static Stretch ultra_expanded() {
            return new Stretch(200000);
        }

        public double getPercentage() {
            return (double)this.value / 1000.0;
        }

        public String toString() {
            Object s = String.valueOf(this.value / 1000);
            int r = this.value % 1000;
            if (r > 0) {
                s = r < 10 ? (String)s + ".00" + r : (r < 100 ? (String)s + ".0" + r : (String)s + "." + r);
            }
            return (String)s + "%";
        }
    }
}

