/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractColor;
import com.storedobject.chart.AbstractDataZoom;
import com.storedobject.chart.AreaStyle;
import com.storedobject.chart.Axis;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.ComponentProperty;
import com.storedobject.chart.CoordinateSystem;
import com.storedobject.chart.HasPolarProperty;
import com.storedobject.chart.HasPosition;
import com.storedobject.chart.LineStyle;
import com.storedobject.chart.Position;
import com.storedobject.chart.Shadow;
import com.storedobject.chart.VisibleProperty;

public class DataZoom
extends AbstractDataZoom
implements HasPosition,
VisibleProperty {
    private boolean show = true;
    private Position position;
    private AbstractColor background;
    private AbstractColor fillerColor;
    private AbstractColor borderColor;
    private HandleStyle handleStyle;
    private DataShadowStyle dataShadowStyle;

    public DataZoom(CoordinateSystem coordinateSystem, Axis ... axis) {
        super("slider", coordinateSystem, axis);
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        sb.append(",\"handleSize\":\"100%\"");
        ComponentPart.encode(sb, null, this.position);
        if (this.background != null) {
            ComponentPart.encode(sb, "backgroundColor", this.background);
        }
        if (this.fillerColor != null) {
            ComponentPart.encode(sb, "fillerColor", this.fillerColor);
        }
        if (this.borderColor != null) {
            ComponentPart.encode(sb, "borderColor", this.borderColor);
        }
        ComponentPart.encode(sb, "handleStyle", this.handleStyle);
        if (this.dataShadowStyle != null && this.dataShadowStyle.valid()) {
            ComponentPart.encode(sb, "dataBackground", this.dataShadowStyle);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.show = visible;
    }

    @Override
    public boolean isVisible() {
        return this.show;
    }

    @Override
    public final Position getPosition(boolean create) {
        if (this instanceof HasPolarProperty) {
            return null;
        }
        if (this.position == null && create) {
            this.position = new Position();
        }
        return this.position;
    }

    @Override
    public final void setPosition(Position position) {
        if (this instanceof HasPolarProperty) {
            return;
        }
        this.position = position;
    }

    public final AbstractColor getBackground() {
        return this.background;
    }

    public void setBackground(AbstractColor background) {
        this.background = background;
    }

    public final AbstractColor getFillerColor() {
        return this.fillerColor;
    }

    public void setFillerColor(AbstractColor fillerColor) {
        this.fillerColor = fillerColor;
    }

    public final AbstractColor getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(AbstractColor borderColor) {
        this.borderColor = borderColor;
    }

    public final HandleStyle getHandleStyle(boolean create) {
        if (this.handleStyle == null && create) {
            this.handleStyle = new HandleStyle();
        }
        return this.handleStyle;
    }

    public void setHandleStyle(HandleStyle handleStyle) {
        this.handleStyle = handleStyle;
    }

    public DataShadowStyle getDataShadowStyle(boolean create) {
        if (this.dataShadowStyle == null && create) {
            this.dataShadowStyle = new DataShadowStyle();
        }
        return this.dataShadowStyle;
    }

    public void setDataShadowStyle(DataShadowStyle dataShadowStyle) {
        this.dataShadowStyle = dataShadowStyle;
    }

    public static class HandleStyle
    implements ComponentProperty {
        private AbstractColor color;
        private AbstractColor borderColor;
        private int borderWidth = -1;
        private LineStyle.Type borderType;
        private Shadow shadow;

        @Override
        public void encodeJSON(StringBuilder sb) {
            if (this.color != null) {
                ComponentPart.encode(sb, "color", this.color);
            }
            if (this.borderColor != null) {
                ComponentPart.encode(sb, "borderColor", this.borderColor);
            }
            if (this.borderType != null) {
                ComponentPart.encode(sb, "borderType", this.borderType.toString().toLowerCase());
            }
            if (this.borderWidth >= 0) {
                ComponentPart.encode(sb, "borderWidth", this.borderWidth);
                this.borderWidth = -1;
            }
            ComponentPart.encode(sb, null, this.shadow);
        }

        public final AbstractColor getColor() {
            return this.color;
        }

        public void setColor(AbstractColor color) {
            this.color = color;
        }

        public final AbstractColor getBorderColor() {
            return this.borderColor;
        }

        public void setBorderColor(AbstractColor color) {
            this.borderColor = color;
        }

        public final int getBorderWidth() {
            return Math.max(this.borderWidth, 0);
        }

        public void setBorderWidth(int borderWidth) {
            this.borderWidth = borderWidth;
        }

        public LineStyle.Type getBorderType() {
            return this.borderType;
        }

        public void setBorderType(LineStyle.Type borderType) {
            this.borderType = borderType;
        }

        public final Shadow getShadow(boolean create) {
            if (this.shadow == null && create) {
                this.shadow = new Shadow();
            }
            return this.shadow;
        }

        public void setShadow(Shadow shadow) {
            this.shadow = shadow;
        }
    }

    public static class DataShadowStyle
    implements ComponentProperty {
        private LineStyle lineStyle;
        private AreaStyle areaStyle;

        @Override
        public void encodeJSON(StringBuilder sb) {
            ComponentPart.encode(sb, null, this.lineStyle);
            ComponentPart.encode(sb, null, this.areaStyle);
        }

        private boolean valid() {
            return this.lineStyle != null || this.areaStyle != null;
        }

        public final LineStyle getLineStyle(boolean create) {
            if (this.lineStyle == null && create) {
                this.lineStyle = new LineStyle();
            }
            return this.lineStyle;
        }

        public void setLineStyle(LineStyle lineStyle) {
            this.lineStyle = lineStyle;
        }

        public final AreaStyle getAreaStyle(boolean create) {
            if (this.areaStyle == null && create) {
                this.areaStyle = new AreaStyle();
            }
            return this.areaStyle;
        }

        public void setAreaStyle(AreaStyle areaStyle) {
            this.areaStyle = areaStyle;
        }
    }
}

