/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.Axis;
import com.storedobject.chart.Chart;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.Component;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.HasData;
import com.storedobject.chart.HasPolarProperty;
import com.storedobject.chart.HasPosition;
import com.storedobject.chart.MarkArea;
import com.storedobject.chart.Position;
import com.storedobject.chart.SOChart;
import com.storedobject.chart.VisiblePart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public abstract class CoordinateSystem
extends VisiblePart
implements Component,
HasPosition,
HasData {
    final List<Axis> axes = new ArrayList<Axis>();
    final Map<Axis, ComponentPart> wrappedAxes = new HashMap<Axis, ComponentPart>();
    private Position position;
    private final List<Chart> charts = new ArrayList<Chart>();

    public void add(Chart ... charts) {
        if (charts != null) {
            for (Chart chart : charts) {
                if (chart.coordinateSystem != null) {
                    chart.coordinateSystem.remove(chart);
                }
                this.charts.add(chart);
                chart.coordinateSystem = this;
                chart.axes = this.axes;
            }
        }
    }

    public void remove(Chart ... charts) {
        if (charts != null) {
            for (Chart chart : charts) {
                this.charts.remove(chart);
                chart.coordinateSystem = null;
                if (chart.axes != this.axes) continue;
                chart.axes = null;
            }
        }
    }

    public void addAxis(Axis ... axes) {
        if (axes != null) {
            for (Axis axis : axes) {
                if (axis == null || this.axes.contains(axis)) continue;
                this.axes.add(axis);
            }
        }
    }

    public void removeAxis(Axis ... axes) {
        if (axes != null) {
            for (Axis axis : axes) {
                if (axis == null) continue;
                this.axes.remove(axis);
            }
        }
    }

    Stream<Axis> axes(Class<?> axisClass) {
        return this.axes.stream().filter(a -> axisClass.isAssignableFrom(a.getClass()));
    }

    boolean noAxis(Class<?> axisClass) {
        return this.axes(axisClass).findAny().isEmpty();
    }

    public Axis getAxis(int index) {
        return this.axes.get(index);
    }

    @Override
    public void validate() throws ChartException {
        for (Axis axis : this.axes) {
            axis.validate();
        }
    }

    @Override
    public void addParts(SOChart soChart) {
        for (Chart chart : this.charts) {
            soChart.addParts(chart);
            soChart.addParts(chart.getData());
            MarkArea ma = chart.getMarkArea(false);
            if (ma == null) continue;
            soChart.addParts(ma.data);
        }
        for (Axis axis : this.axes) {
            axis.soChart = soChart;
            soChart.addParts(this.wrap(axis));
        }
    }

    @Override
    public void declareData(Set<AbstractDataProvider<?>> dataSet) {
        for (Chart chart : this.charts) {
            chart.declareData(dataSet);
        }
    }

    private ComponentPart wrap(Axis axis) {
        ComponentPart aw = this.wrappedAxes.get(axis);
        if (aw == null) {
            aw = axis.wrap(this);
            this.wrappedAxes.put(axis, aw);
        }
        return aw;
    }

    int getAxisIndex(Axis axis) {
        return this.wrap(axis).getRenderingIndex();
    }

    @Override
    public final Position getPosition(boolean create) {
        if (this instanceof HasPolarProperty) {
            return null;
        }
        if (this.position == null && create) {
            this.position = new Position();
        }
        return this.position;
    }

    @Override
    public final void setPosition(Position position) {
        if (this instanceof HasPolarProperty) {
            return;
        }
        this.position = position;
    }

    String systemName() {
        return null;
    }

    String[] axesData() {
        return null;
    }
}

