/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractPart;
import com.storedobject.chart.Animation;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.Emphasis;
import com.storedobject.chart.HasAnimation;
import com.storedobject.chart.HasEmphasis;
import com.storedobject.chart.HasItemStyle;
import com.storedobject.chart.HasLabel;
import com.storedobject.chart.HasPadding;
import com.storedobject.chart.HasPolarProperty;
import com.storedobject.chart.HasPosition;
import com.storedobject.chart.ItemStyle;
import com.storedobject.chart.Label;
import com.storedobject.chart.Padding;
import com.storedobject.chart.PolarProperty;
import com.storedobject.chart.Position;
import com.storedobject.chart.VisibleProperty;

public class ComposedPart
extends AbstractPart
implements HasPosition,
HasPadding,
HasPolarProperty,
HasAnimation,
HasEmphasis,
HasLabel,
HasItemStyle,
VisibleProperty {
    private final boolean hasVisibility;
    private final boolean hasPosition;
    private final boolean hasPadding;
    private final boolean hasPolarProperty;
    private final boolean hasAnimation;
    private final boolean hasEmphasis;
    private final boolean hasLabel;
    private final boolean hasItemStyle;
    private boolean show = true;
    private PolarProperty polarProperty;
    private Position position;
    private Padding padding;
    private Animation animation;
    private Emphasis emphasis;
    private Label label;
    private ItemStyle itemStyle;

    public ComposedPart(boolean hasVisibility, boolean hasPosition, boolean hasPadding, boolean hasPolarProperty, boolean hasAnimation, boolean hasEmphasis, boolean hasLabel, boolean hasItemStyle) {
        this.hasVisibility = hasVisibility;
        this.hasPosition = hasPosition;
        this.hasPadding = hasPadding;
        this.hasPolarProperty = hasPolarProperty;
        this.hasAnimation = hasAnimation;
        this.hasEmphasis = hasEmphasis;
        this.hasLabel = hasLabel;
        this.hasItemStyle = hasItemStyle;
    }

    @Override
    public void setVisible(boolean visible) {
        this.show = visible;
    }

    @Override
    public boolean isVisible() {
        return this.show;
    }

    @Override
    public void validate() throws ChartException {
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        if (this.hasVisibility) {
            ComponentPart.encode(sb, "show", this.show);
        }
    }

    @Override
    public final PolarProperty getPolarProperty(boolean create) {
        if (this.hasPolarProperty && this.polarProperty == null && create) {
            this.polarProperty = new PolarProperty();
        }
        return this.polarProperty;
    }

    @Override
    public final void setPolarProperty(PolarProperty polarProperty) {
        if (this.hasPolarProperty) {
            this.polarProperty = polarProperty;
        }
    }

    @Override
    public final Position getPosition(boolean create) {
        if (this.hasPosition && this.position == null && create) {
            this.position = new Position();
        }
        return this.position;
    }

    @Override
    public final void setPosition(Position position) {
        if (this.hasPosition) {
            this.position = position;
        }
    }

    @Override
    public Padding getPadding(boolean create) {
        if (this.hasPadding && this.padding == null && create) {
            this.padding = new Padding();
        }
        return this.padding;
    }

    @Override
    public void setPadding(Padding padding) {
        if (this.hasPadding) {
            this.padding = padding;
        }
    }

    @Override
    public Animation getAnimation(boolean create) {
        if (this.hasAnimation && create && this.animation == null) {
            this.animation = new Animation();
        }
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        if (this.hasAnimation) {
            this.animation = animation;
        }
    }

    @Override
    public Emphasis getEmphasis(boolean create) {
        if (this.hasEmphasis && this.emphasis == null && create) {
            this.emphasis = new Emphasis();
        }
        return this.emphasis;
    }

    @Override
    public void setEmphasis(Emphasis emphasis) {
        if (this.hasEmphasis) {
            this.emphasis = emphasis;
        }
    }

    @Override
    public Label getLabel(boolean create) {
        Class<? extends Label> labelClass;
        if (this.hasLabel && this.label == null && create && (labelClass = this.getLabelClass()) != null) {
            try {
                this.label = labelClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.label;
    }

    @Override
    public void setLabel(Label label) {
        if (this.hasLabel) {
            if (label != null && !this.getLabelClass().isAssignableFrom(label.getClass())) {
                return;
            }
            this.label = label;
        }
    }

    protected Class<? extends Label> getLabelClass() {
        return null;
    }

    @Override
    public ItemStyle getItemStyle(boolean create) {
        if (this.itemStyle == null && create && this.hasItemStyle) {
            this.itemStyle = new ItemStyle();
        }
        return this.itemStyle;
    }

    @Override
    public void setItemStyle(ItemStyle itemStyle) {
        if (this.hasItemStyle) {
            this.itemStyle = itemStyle;
        }
    }
}

