/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractColor;
import java.util.Objects;

public class Color
extends AbstractColor {
    public static final Color TRANSPARENT = new Color("transparent");
    private int red;
    private int green;
    private int blue;
    private int alpha = Integer.MAX_VALUE;
    private String colorName;

    public Color(int red, int green, int blue) {
        this(red, green, blue, Integer.MAX_VALUE);
    }

    public Color(int red, int green, int blue, int alpha) {
        this.set(red, green, blue, alpha);
    }

    public void set(int red, int green, int blue) {
        this.set(red, green, blue, Integer.MAX_VALUE);
    }

    public void set(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        this.validate();
    }

    public Color(String hexValue) {
        this.set(hexValue);
    }

    public void set(String hexValue) {
        if (hexValue == null) {
            return;
        }
        if (hexValue.startsWith("#")) {
            hexValue = hexValue.substring(1);
        }
        if (!Color.isHex(hexValue)) {
            this.colorName = hexValue;
            return;
        }
        if ((hexValue = hexValue.toUpperCase()).length() > 8) {
            hexValue = hexValue.substring(0, 8);
        }
        if (hexValue.length() > 6) {
            this.alpha = Color.value(hexValue.substring(6));
            hexValue = hexValue.substring(0, 6);
        }
        if (hexValue.length() <= 2) {
            this.red = Color.value(hexValue);
            this.blue = 0;
            this.green = 0;
            return;
        }
        this.red = Color.value(hexValue.substring(0, 2));
        if ((hexValue = hexValue.substring(2)).length() <= 2) {
            this.green = Color.value(hexValue);
            this.blue = 0;
            return;
        }
        this.green = Color.value(hexValue.substring(0, 2));
        this.blue = Color.value(hexValue.substring(2));
    }

    private static int value(String hex) {
        return Integer.parseInt(hex, 16);
    }

    private static boolean isHex(String s) {
        return s.chars().allMatch(Color::isHex);
    }

    private static boolean isHex(int c) {
        return c >= 48 && c <= 57 || c >= 65 && c <= 70 || c >= 97 && c <= 102;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        this.validate();
    }

    public void setRed(int red) {
        this.red = red;
        this.validate();
    }

    public void setGreen(int green) {
        this.green = green;
        this.validate();
    }

    public void setBlue(int blue) {
        this.blue = blue;
        this.validate();
    }

    private void validate() {
        this.red = Math.max(0, Math.min(this.red, 255));
        this.green = Math.max(0, Math.min(this.green, 255));
        this.blue = Math.max(0, Math.min(this.blue, 255));
        if (this.alpha != Integer.MAX_VALUE) {
            this.alpha = Math.max(0, Math.min(this.alpha, 100));
        }
    }

    public String toString() {
        if (this.colorName != null) {
            return "\"" + this.colorName + "\"";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"rgb");
        if (this.alpha != Integer.MAX_VALUE) {
            sb.append('a');
        }
        sb.append('(').append(this.red).append(',').append(this.green).append(',').append(this.blue);
        if (this.alpha != Integer.MAX_VALUE) {
            sb.append(',').append((double)this.alpha / 100.0);
        }
        sb.append(")\"");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color = (Color)o;
        if (this.colorName != null || color.colorName != null) {
            return Objects.equals(this.colorName, color.colorName);
        }
        return this.red == color.red && this.green == color.green && this.blue == color.blue && this.alpha == color.alpha;
    }

    public int hashCode() {
        return Objects.hash(this.red, this.green, this.blue, this.alpha, this.colorName);
    }
}

