/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

public enum ChartType {
    Line,
    Bar,
    Pie(new String[]{"itemName", "value"}, false),
    Scatter,
    EffectScatter,
    Funnel(new String[]{"itemName", "value"}, false),
    Radar(new String[0]),
    Gauge(new String[0], false),
    Tree(new String[0], false),
    Treemap(new String[0], false),
    Sunburst(new String[0], false),
    Heatmap(new String[0], true),
    Graph(new String[0], false),
    Candlestick,
    Sankey(new String[0], false),
    XYGraph("graph"),
    Boxplot;

    private final String[] axes;
    private final boolean coordinateSystem;
    private final String type;

    private ChartType() {
        this(new String[]{"x", "y"});
    }

    private ChartType(String type) {
        this(new String[]{"x", "y"}, true, type);
    }

    private ChartType(String[] axes) {
        this(axes, true, null);
    }

    private ChartType(String[] axes, boolean coordinateSystem) {
        this(axes, coordinateSystem, null);
    }

    private ChartType(String[] axes, boolean coordinateSystem, String type) {
        this.axes = axes;
        this.coordinateSystem = coordinateSystem;
        if (type == null) {
            String t = this.name();
            type = Character.toLowerCase(t.charAt(0)) + t.substring(1);
        }
        this.type = type;
    }

    public String[] getAxes() {
        return this.axes;
    }

    public boolean requireCoordinateSystem() {
        return this.coordinateSystem;
    }

    public String getType() {
        return this.type;
    }
}

