/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.ChartType;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.PointSymbol;
import com.storedobject.chart.Tooltip;
import com.storedobject.chart.XYDataChart;
import java.util.List;

public class BubbleChart
extends XYDataChart {
    private PointSymbol pointSymbol;
    private double bubbleSize = 1.0;
    private String valuePrefix;
    private String valueSuffix;

    public BubbleChart(AbstractDataProvider<?> xData, AbstractDataProvider<?> yData) {
        super(ChartType.Scatter, xData, yData);
        this.getTooltip(true).append(this);
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        if (this.bubbleSize >= 0.0) {
            StringBuilder s = new StringBuilder();
            ComponentPart.encodeFunction(s, null, "return v[2]*" + this.bubbleSize, "v");
            this.getPointSymbol((boolean)true).size = s.toString();
        }
        if (this.pointSymbol != null) {
            this.pointSymbol.encodeJSON(sb);
        }
    }

    public void setBubbleSize(double multiplicationFactor) {
        this.bubbleSize = multiplicationFactor;
    }

    public void setValuePrefix(String valuePrefix) {
        this.valuePrefix = valuePrefix;
        this.tooltip();
    }

    public void setValueSuffix(String valueSuffix) {
        this.valueSuffix = valueSuffix;
        this.tooltip();
    }

    private void tooltip() {
        Tooltip tooltip = this.getTooltip(true);
        List<Object> parts = tooltip.parts;
        parts.clear();
        tooltip.append(this.valuePrefix);
        tooltip.append(this);
        tooltip.append(this.valueSuffix);
    }

    public PointSymbol getPointSymbol(boolean create) {
        if (this.pointSymbol == null && create) {
            this.pointSymbol = new PointSymbol();
        }
        return this.pointSymbol;
    }

    public void setPointSymbol(PointSymbol pointSymbol) {
        this.pointSymbol = pointSymbol;
        this.bubbleSize = -1.0;
    }
}

