/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.AbstractProject;
import com.storedobject.chart.Axis;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.ComponentGroup;
import com.storedobject.chart.CoordinateSystem;
import com.storedobject.chart.DataType;
import com.storedobject.chart.DataZoom;
import com.storedobject.chart.Font;
import com.storedobject.chart.LineChart;
import com.storedobject.chart.Position;
import com.storedobject.chart.RectangularCoordinate;
import com.storedobject.chart.SOChart;
import com.storedobject.chart.Size;
import com.storedobject.chart.Text;
import com.storedobject.chart.Tooltip;
import com.storedobject.chart.XAxis;
import com.storedobject.chart.YAxis;

public abstract class AbstractGanttChart
implements ComponentGroup {
    private RectangularCoordinate coordinate;
    private XAxis timeAxis;
    private YAxis taskAxis;
    private Today today;
    private final AbstractProject project;
    private final Text error;
    private Tasks tasks;
    private TaskAxisLabels taskAxisLabels;
    private TaskDependencies taskDependencies;
    private TaskBands taskBands;
    private DataZoom timeZoom;
    private DataZoom taskZoom;

    public AbstractGanttChart(AbstractProject project) {
        this.project = project;
        this.error = new Text("");
        this.error.setFont(new Font(Font.Family.sans_serif(), Font.Size.larger()));
        this.error.getPosition(true).center();
        this.error.setDraggable(true);
    }

    @Override
    public void addParts(SOChart soChart) {
        AbstractDataProvider<String> depData;
        AbstractDataProvider<?> data;
        soChart.disableDefaultLegend();
        soChart.remove(this.error);
        soChart.add(this.getC());
        try {
            this.project.validateConstraints();
        }
        catch (ChartException e) {
            this.error.setText(e.getMessage());
            soChart.add(this.error);
            return;
        }
        if (this.project.isEmpty()) {
            this.error.setText("Empty project - " + this.project.getName());
            soChart.add(this.error);
            return;
        }
        if (this.today == null && (data = this.project.dataForToday()) != null) {
            this.today = new Today(this, data);
        }
        if (this.taskBands == null) {
            this.taskBands = new TaskBands();
        }
        if (this.tasks == null) {
            this.tasks = new Tasks();
        }
        if (this.taskAxisLabels == null) {
            this.taskAxisLabels = new TaskAxisLabels();
        }
        if (this.taskDependencies == null && (depData = this.project.dependencies()) != null) {
            this.taskDependencies = new TaskDependencies(this, depData);
        }
        this.taskAxis.setMax(this.project.getRowCount());
        soChart.add(this.taskBands, this.tasks, this.today, this.taskAxisLabels, this.taskDependencies, this.getTimeAxisZoom(), this.getYAxisZoom());
    }

    @Override
    public void removeParts(SOChart soChart) {
        soChart.remove(this.coordinate, this.today, this.error, this.taskBands, this.tasks, this.today, this.taskAxisLabels, this.taskDependencies, this.timeZoom, this.taskZoom);
    }

    DataZoom getYAxisZoom() {
        if (this.taskZoom == null) {
            this.taskZoom = new DataZoom(this.getC(), this.getYAxis());
            this.taskZoom.setFilterMode(2);
            this.taskZoom.setShowDetail(false);
            this.taskZoom.setZ(7);
        }
        return this.taskZoom;
    }

    public DataZoom getTimeAxisZoom() {
        if (this.timeZoom == null) {
            this.timeZoom = new DataZoom(this.getC(), this.getTimeAxis());
            this.timeZoom.setFilterMode(2);
            this.timeZoom.setShowDetail(false);
            this.timeZoom.setZ(7);
        }
        return this.timeZoom;
    }

    public RectangularCoordinate getCoordinateSystem() {
        if (this.coordinate == null) {
            this.coordinate = new RectangularCoordinate(this.getTimeAxis(), this.getYAxis());
            Position p = this.coordinate.getPosition(true);
            p.setTop(Size.pixels(40));
            p.setBottom(Size.pixels(60));
            p.setLeft(Size.pixels(225));
            p.setRight(Size.pixels(40));
        }
        return this.coordinate;
    }

    private CoordinateSystem getC() {
        return this.getCoordinateSystem();
    }

    public XAxis getTimeAxis() {
        if (this.timeAxis == null) {
            this.timeAxis = new XAxis(this.project.getDurationType().isDateBased() ? DataType.DATE : DataType.TIME);
            this.timeAxis.getLabel(true).getAlignment(true).center();
            this.timeAxis.getTicks(true).hide();
            this.timeAxis.setZ(7);
        }
        return this.timeAxis;
    }

    YAxis getYAxis() {
        if (this.taskAxis == null) {
            this.taskAxis = new YAxis(DataType.NUMBER);
            this.taskAxis.getLabel(true).hide();
            this.taskAxis.getTicks(true).hide();
            this.taskAxis.setMin(0);
        }
        return this.taskAxis;
    }

    private class Today
    extends LineChart {
        private final AbstractDataProvider<?> data;

        private Today(AbstractGanttChart abstractGanttChart, AbstractDataProvider<?> data) {
            this.data = data;
            this.setCustomRenderer("VLine");
            this.setZ(6);
            this.plotOn(abstractGanttChart.getC(), new Axis[0]);
        }

        @Override
        protected AbstractDataProvider<?> dataToEmbed() {
            return this.data;
        }

        @Override
        protected AbstractDataProvider<?> mainData() {
            return this.data;
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            sb.append(",\"encode\":{\"x\":0,\"y\":-1}");
        }
    }

    private class TaskBands
    extends LineChart {
        private AbstractDataProvider<?> bands;

        private TaskBands() {
            this.setCustomRenderer("HBand");
            this.setZ(1);
            this.plotOn(AbstractGanttChart.this.getC(), new Axis[0]);
        }

        @Override
        protected AbstractDataProvider<?> dataToEmbed() {
            if (this.bands == null) {
                this.bands = AbstractGanttChart.this.project.bands();
            }
            return this.bands;
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            sb.append(",\"encode\":{\"x\":-1,\"y\":0}");
        }
    }

    private class Tasks
    extends LineChart {
        private AbstractDataProvider<?> data;

        private Tasks() {
            this.setCustomRenderer("HBar");
            this.setZ(4);
            this.setName("Tasks");
            this.plotOn(AbstractGanttChart.this.getC(), AbstractGanttChart.this.getTimeAxis(), AbstractGanttChart.this.getYAxis());
            Tooltip tooltip = new Tooltip();
            tooltip.append(AbstractGanttChart.this.project.tooltipLabels());
            this.setTooltip(tooltip);
        }

        @Override
        protected AbstractDataProvider<?> dataToEmbed() {
            if (this.data == null) {
                this.data = AbstractGanttChart.this.project.taskData();
            }
            return this.data;
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            sb.append(",\"encode\":{\"x\":[2,3],\"y\":0}");
        }
    }

    private class TaskAxisLabels
    extends LineChart {
        private AbstractDataProvider<?> data;

        private TaskAxisLabels() {
            this.setCustomRenderer("VAxisLabel");
            this.setZ(5);
            this.plotOn(AbstractGanttChart.this.getC(), new Axis[0]);
        }

        @Override
        protected AbstractDataProvider<?> dataToEmbed() {
            if (this.data == null) {
                this.data = AbstractGanttChart.this.project.axisLabels();
            }
            return this.data;
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            sb.append(",\"encode\":{\"x\":-1,\"y\":0}");
        }
    }

    private class TaskDependencies
    extends LineChart {
        private final AbstractDataProvider<?> data;

        private TaskDependencies(AbstractGanttChart abstractGanttChart, AbstractDataProvider<?> data) {
            this.setCustomRenderer("Dependency");
            this.data = data;
            this.setZ(2);
            this.setName("Dependencies");
            this.plotOn(abstractGanttChart.getC(), abstractGanttChart.getTimeAxis(), abstractGanttChart.getYAxis());
        }

        @Override
        protected AbstractDataProvider<?> dataToEmbed() {
            return this.data;
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            sb.append(",\"encode\":{\"x\":-1,\"y\":0}");
        }
    }
}

