/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.DataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class AbstractData<T>
extends ArrayList<T>
implements AbstractDataProvider<T> {
    private int serial = -1;
    private final DataType dataType;
    private String name;

    @SafeVarargs
    public AbstractData(Class<T> dataClass, T ... data) {
        this(AbstractData.dataType(dataClass), data);
    }

    @SafeVarargs
    public AbstractData(DataType dataType, T ... data) {
        this.dataType = dataType;
        if (data != null) {
            this.addAll(Arrays.asList(data));
        }
    }

    private static DataType dataType(Class<?> dataClass) {
        for (DataType dt : DataType.values()) {
            if (!dt.getType().isAssignableFrom(dataClass)) continue;
            return dt;
        }
        return DataType.CATEGORY;
    }

    @Override
    public final DataType getDataType() {
        return this.dataType;
    }

    @Override
    public final int getSerial() {
        return this.serial;
    }

    @Override
    public final void setSerial(int serial) {
        this.serial = serial;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<T> asList() {
        return this;
    }

    @Override
    public Stream<T> stream() {
        return super.stream();
    }
}

