/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.Chart;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.ChartType;

public abstract class AbstractChart
extends Chart {
    private final boolean axesBased;

    public AbstractChart(ChartType type, AbstractDataProvider<?> ... data) {
        this(type, true, data);
    }

    public AbstractChart(ChartType type, boolean axesBased, AbstractDataProvider<?> ... data) {
        super(type, new AbstractDataProvider[0]);
        super.setType(type);
        this.axesBased = axesBased;
        if (axesBased) {
            AbstractDataProvider[] d = new AbstractDataProvider[type.getAxes().length];
            if (data != null) {
                for (int i = 0; i < data.length && i != d.length; ++i) {
                    d[i] = data[i];
                }
            }
            super.setData(d);
        } else {
            super.setData(data);
        }
    }

    @Override
    public final void setType(ChartType type) {
    }

    @Override
    public void validate() throws ChartException {
        super.validate();
        if (this.axesBased && this.dataToEmbed() == null) {
            AbstractDataProvider<?>[] d = this.getData();
            for (int i = 0; i < d.length; ++i) {
                if (d[i] != null) continue;
                throw new ChartException("Data for " + this.axisName(i) + " not set for " + this.className());
            }
        }
    }

    @Override
    public final void setData(AbstractDataProvider<?> ... data) {
        if (this.axesBased) {
            throw new RuntimeException();
        }
        super.setData(data);
    }

    protected final void setData(AbstractDataProvider<?> data, int index) {
        AbstractDataProvider<?>[] d = this.getData();
        if (index >= 0 && index < d.length) {
            d[index] = data;
        }
    }
}

