/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.Axis;
import com.storedobject.chart.BasicInternalDataProvider;
import com.storedobject.chart.Chart;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.ChartType;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.RectangularCoordinate;
import com.storedobject.chart.SOChart;
import com.storedobject.chart.VisualMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public abstract class XYDataChart
extends Chart {
    private final List<Value> data = new ArrayList<Value>();
    private final XYData xyData = new XYData();
    private VisualMap visualMap = new VisualMap(this);

    public XYDataChart(ChartType chartType, AbstractDataProvider<?> xData, AbstractDataProvider<?> yData) {
        super(chartType, new AbstractDataProvider[0]);
        this.setData(xData, yData, this.xyData);
    }

    @Override
    public void validate() throws ChartException {
        super.validate();
        if (this.coordinateSystem == null || !RectangularCoordinate.class.isAssignableFrom(this.coordinateSystem.getClass())) {
            throw new ChartException(ComponentPart.className(this.getClass()) + " must be plotted on a rectangular coordinate system");
        }
        RectangularCoordinate rc = (RectangularCoordinate)this.coordinateSystem;
        rc.validate();
        ((Axis)rc.axes.get(0)).setData(this.getData()[0]);
        ((Axis)rc.axes.get(1)).setData(this.getData()[1]);
    }

    public void addData(int xIndex, int yIndex, Number value) {
        this.data.add(new Value(xIndex, yIndex, value));
    }

    public void addData(String xValue, int yIndex, Number value) {
        this.data.add(new Value(xValue, yIndex, value));
    }

    public void addData(int xIndex, String yValue, Number value) {
        this.data.add(new Value(xIndex, yValue, value));
    }

    public void addData(String xValue, String yValue, Number value) {
        this.data.add(new Value(xValue, yValue, value));
    }

    @Override
    protected AbstractDataProvider<?> dataToEmbed() {
        return this.xyData;
    }

    @Override
    protected int dataValueIndex() {
        return 2;
    }

    @Override
    public void addParts(SOChart soChart) {
        super.addParts(soChart);
        if (this.visualMap != null) {
            soChart.addParts(this.visualMap);
        }
    }

    public final VisualMap getVisualMap() {
        return this.visualMap;
    }

    public void setVisualMap(VisualMap visualMap) {
        this.visualMap = visualMap;
    }

    private class XYData
    extends BasicInternalDataProvider<Value> {
        private XYData() {
        }

        @Override
        public Stream<Value> stream() {
            return XYDataChart.this.data.stream();
        }

        @Override
        public Object getMin() {
            Value v = this.stream().min(new XYValueComparator()).orElse(null);
            return v == null ? (Number)null : (Number)v.value;
        }

        @Override
        public Object getMax() {
            Value v = this.stream().max(new XYValueComparator()).orElse(null);
            return v == null ? (Number)null : (Number)v.value;
        }

        @Override
        public void encode(StringBuilder sb, Value value) {
            Number n;
            sb.append('[');
            Object object = value.xIndex;
            if (object instanceof Number) {
                n = (Number)object;
                sb.append(n.intValue());
            } else {
                sb.append('\"').append(value.xIndex).append('\"');
            }
            sb.append(',');
            object = value.yIndex;
            if (object instanceof Number) {
                n = (Number)object;
                sb.append(n.intValue());
            } else {
                sb.append('\"').append(value.yIndex).append('\"');
            }
            sb.append(',');
            sb.append(value.value).append(']');
        }

        private static class XYValueComparator
        implements Comparator<Value> {
            private static final AbstractDataProvider.NumberComparator numberComparator = new AbstractDataProvider.NumberComparator();

            private XYValueComparator() {
            }

            @Override
            public int compare(Value o1, Value o2) {
                return numberComparator.compare(o1.value, o2.value);
            }
        }
    }

    private record Value(Object xIndex, Object yIndex, Number value) {
    }
}

