/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.AbstractProject;
import com.storedobject.chart.BasicDataProvider;
import com.storedobject.chart.CategoryDataProvider;
import com.storedobject.chart.Color;
import com.storedobject.chart.ComponentGroup;
import com.storedobject.chart.DataType;
import com.storedobject.chart.DataZoom;
import com.storedobject.chart.LineChart;
import com.storedobject.chart.Position;
import com.storedobject.chart.RectangularCoordinate;
import com.storedobject.chart.SOChart;
import com.storedobject.chart.Size;
import com.storedobject.chart.Tooltip;
import com.storedobject.chart.XAxis;
import com.storedobject.chart.YAxis;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class XRangeChart<X, Y>
implements ComponentGroup {
    private final List<Data> data = new ArrayList<Data>();
    private XAxis xAxis;
    private YAxis yAxis;
    private RectangularCoordinate coordinate;
    private RChart chart;
    private CategoryDataProvider yData;
    private byte showProgress = (byte)-1;
    private boolean showProgressLabel = false;
    private DataZoom xZoom;
    private DataZoom yZoom;

    public void addData(X xLowerValue, X xUpperValue, Y yValue, String label, Color color) {
        this.addData(xLowerValue, xUpperValue, yValue, label, color, 0.0);
    }

    public void addData(X xLowerValue, X xUpperValue, Y yValue, String label, Color color, String extraInfo) {
        this.addData(xLowerValue, xUpperValue, yValue, label, color, 0.0, extraInfo);
    }

    public void addData(X xLowerValue, X xUpperValue, Y yValue, Color color, double progressPercentage) {
        this.addData(xLowerValue, xUpperValue, yValue, null, color, progressPercentage);
    }

    public void addData(X xLowerValue, X xUpperValue, Y yValue, Color color, double progressPercentage, String extraInfo) {
        this.addData(xLowerValue, xUpperValue, yValue, null, color, progressPercentage, extraInfo);
    }

    public void addData(X xLowerValue, X xUpperValue, Y yValue, Color color) {
        this.addData(xLowerValue, xUpperValue, yValue, null, color, 0.0, null);
    }

    public void addData(X xLowerValue, X xUpperValue, Y yValue, Color color, String extraInfo) {
        this.addData(xLowerValue, xUpperValue, yValue, null, color, 0.0, extraInfo);
    }

    public void addData(X xLowerValue, X xUpperValue, Y yValue, String label, Color color, double progressPercentage) {
        this.addData(xLowerValue, xUpperValue, yValue, label, color, progressPercentage, null);
    }

    public void addData(X xLowerValue, X xUpperValue, Y yValue, String label, Color color, double progressPercentage, String extraInfo) {
        this.data.add(new Data(xLowerValue, xUpperValue, yValue, label, color, progressPercentage, extraInfo));
    }

    public void clearData() {
        this.data.clear();
    }

    @Override
    public void addParts(SOChart soChart) {
        if (this.chart == null) {
            this.chart = new RChart();
        }
        soChart.addData(this.yData);
        soChart.add(this.chart, this.xZoom, this.yZoom);
    }

    @Override
    public void removeParts(SOChart soChart) {
        soChart.remove(this.chart, this.xZoom, this.yZoom);
    }

    public DataZoom getXZoom(boolean create) {
        if (this.xZoom == null && create) {
            this.xZoom = new DataZoom(this.getCoordinateSystem(), this.getXAxis());
            this.xZoom.setFilterMode(2);
            this.xZoom.setShowDetail(false);
            this.xZoom.setZ(7);
        }
        return this.xZoom;
    }

    public DataZoom getYZoom(boolean create) {
        if (this.yZoom == null && create) {
            this.yZoom = new DataZoom(this.getCoordinateSystem(), this.getYAxis());
            this.yZoom.setFilterMode(2);
            this.yZoom.setShowDetail(false);
            this.yZoom.setZ(7);
        }
        return this.yZoom;
    }

    public void showProgressBar(boolean showProgress) {
        this.showProgress = (byte)(showProgress ? 1 : 0);
    }

    public void showProgressLabel(boolean showProgressLabel) {
        this.showProgressLabel = showProgressLabel;
    }

    public XAxis getXAxis() {
        if (this.xAxis == null && !this.data.isEmpty()) {
            this.xAxis = new XAxis(DataType.guessType(this.data.getFirst().xLowerValue));
        }
        return this.xAxis;
    }

    public YAxis getYAxis() {
        if (this.yAxis == null && !this.data.isEmpty()) {
            this.yAxis = new YAxis(DataType.guessType(this.data.getFirst().yValue));
        }
        return this.yAxis;
    }

    public void setYData(CategoryDataProvider yData) {
        if (this.getYAxis().getDataType().equals((Object)DataType.CATEGORY)) {
            this.yData = yData;
            this.yAxis.setData(yData);
        }
    }

    public RectangularCoordinate getCoordinateSystem() {
        if (this.coordinate == null) {
            this.coordinate = new RectangularCoordinate(this.getXAxis(), this.getYAxis());
            Position p = this.coordinate.getPosition(true);
            p.setBottom(Size.pixels(60));
        }
        return this.coordinate;
    }

    public String formatValue(Object value) {
        if (value instanceof LocalDate) {
            LocalDate d = (LocalDate)value;
            return DateTimeFormatter.ofPattern("MMM dd, yyyy").format(d);
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime d = (LocalDateTime)value;
            return DateTimeFormatter.ofPattern("MMM dd, yyyy HH:mm:ss").format(d);
        }
        return value.toString();
    }

    public String formatYValue(Y value) {
        String s = this.formatValue(value);
        return s == null ? null : s + ": ";
    }

    public String formatXValue(X value) {
        return this.formatValue(value);
    }

    public String formatXValue(X xLowerValue, X xUpperValue) {
        String s = this.formatXValue(xLowerValue);
        if (s == null) {
            return null;
        }
        return s + " - " + this.formatXValue(xUpperValue);
    }

    public String getTooltipText(X xLowerValue, X xUpperValue, Y yValue, String label, double progress, String extraInfo) {
        Object sb = "";
        String s = this.formatYValue(yValue);
        if (s != null) {
            sb = (String)sb + s;
        }
        if ((s = this.formatXValue(xLowerValue, xUpperValue)) != null) {
            sb = (String)sb + s;
        }
        if (extraInfo != null) {
            if (((String)sb).isEmpty()) {
                return extraInfo;
            }
            sb = (String)sb + "\n" + extraInfo;
        }
        return sb;
    }

    private class Data {
        final X xLowerValue;
        final X xUpperValue;
        final Y yValue;
        final String label;
        final Color color;
        final double progress;
        final String extraInfo;

        private Data(X xLowerValue, X xUpperValue, Y yValue, String label, Color color, double progress, String extraInfo) {
            this.xLowerValue = xLowerValue;
            this.xUpperValue = xUpperValue;
            this.yValue = yValue;
            this.label = label;
            this.color = color;
            this.progress = Math.min(Math.max(0.0, progress), 100.0);
            this.extraInfo = extraInfo;
        }

        String label() {
            return (this.label == null ? "" : this.label) + this.p();
        }

        private String p() {
            if (!XRangeChart.this.showProgressLabel) {
                return "";
            }
            return " (" + AbstractProject.trim(this.progress) + "%)";
        }

        private String tooltip() {
            String s;
            for (s = XRangeChart.this.getTooltipText(this.xLowerValue, this.xUpperValue, this.yValue, this.label, this.progress, this.extraInfo); s != null && s.endsWith("\n"); s = s.substring(0, s.length() - 1)) {
            }
            return s == null ? "" : s.replace("\n", "<br>");
        }
    }

    private class RChart
    extends LineChart {
        private AbstractDataProvider<?> data;

        private RChart() {
            this.setCustomRenderer("HBar");
            this.plotOn(XRangeChart.this.getCoordinateSystem(), XRangeChart.this.getXAxis(), XRangeChart.this.getYAxis());
            Tooltip tooltip = new Tooltip();
            tooltip.append(new BasicDataProvider<String>(this){
                final /* synthetic */ RChart this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public Stream<String> stream() {
                    return this.this$1.XRangeChart.this.data.stream().map(Data::tooltip);
                }

                @Override
                public DataType getDataType() {
                    return DataType.CATEGORY;
                }
            });
            this.setTooltip(tooltip);
        }

        @Override
        protected AbstractDataProvider<?> dataToEmbed() {
            if (this.data == null) {
                final boolean progress = XRangeChart.this.showProgress == -1 ? XRangeChart.this.data.stream().anyMatch(d -> d.progress > 0.0) : XRangeChart.this.showProgress == 1;
                this.data = new BasicDataProvider<String>(this){
                    final /* synthetic */ RChart this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public Stream<String> stream() {
                        return this.this$1.XRangeChart.this.data.stream().map(d -> "[" + this.this$1.XRangeChart.this.yAxis.getDataType().encode(d.yValue) + ",\"" + d.label() + "\"," + this.this$1.XRangeChart.this.xAxis.getDataType().encode(d.xLowerValue) + "," + this.this$1.XRangeChart.this.xAxis.getDataType().encode(d.xUpperValue) + "," + (progress ? d.progress : 100.0) + "," + String.valueOf(d.color) + "," + String.valueOf(d.color) + "," + String.valueOf(progress ? "\"black\"" : d.color) + "]");
                    }

                    @Override
                    public void encode(StringBuilder sb, String value) {
                        sb.append(value);
                    }
                };
            }
            return this.data;
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            sb.append(",\"encode\":{\"x\":[2,3],\"y\":0}");
        }
    }
}

