/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.Chart;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.Component;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.ComponentProperty;
import com.storedobject.chart.HasPosition;
import com.storedobject.chart.Position;
import com.storedobject.chart.VisibleProperty;
import com.storedobject.helper.ID;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class VisualMap
implements Component,
HasPosition,
VisibleProperty {
    private int serial;
    private final long id = ID.newID();
    private boolean continuous = true;
    private boolean calculable = true;
    private boolean vertical = false;
    private boolean show = true;
    private Chart chart;
    private Position position = new Position();
    private Number min;
    private Number max;
    private Range inRange;
    private Range outOfRange;

    public VisualMap() {
        this(null);
    }

    public VisualMap(Chart chart) {
        this.chart = chart;
        this.position.alignBottom();
        this.position.justifyCenter();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setSerial(int serial) {
        this.serial = serial;
    }

    @Override
    public int getSerial() {
        return this.serial;
    }

    @Override
    public void validate() throws ChartException {
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        ComponentPart.encode(sb, "id", this.id);
        ComponentPart.encode(sb, "calculable", this.calculable);
        ComponentPart.encode(sb, "type", this.continuous ? "continuous" : "piecewise");
        if (this.chart != null) {
            ComponentPart.encode(sb, "seriesIndex", this.chart.getSerial());
            if (this.min == null) {
                ComponentPart.encode(sb, "min", this.chart.getMin());
            }
            if (this.max == null) {
                ComponentPart.encode(sb, "max", this.chart.getMax());
            }
        }
        if (this.min != null) {
            ComponentPart.encode(sb, "min", this.min);
        }
        if (this.max != null) {
            ComponentPart.encode(sb, "max", this.max);
        }
        ComponentPart.encode(sb, "orient", this.vertical ? "vertical" : "horizontal");
        ComponentPart.encode(sb, null, this.position);
        ComponentPart.encode(sb, "show", this.show);
        ComponentPart.encode(sb, "inRange", this.inRange);
        ComponentPart.encode(sb, "outOfRange", this.outOfRange);
    }

    public final boolean isContinuous() {
        return this.continuous;
    }

    public void setContinuous(boolean continuous) {
        this.continuous = continuous;
    }

    public final boolean isCalculable() {
        return this.calculable;
    }

    public void setCalculable(boolean calculable) {
        this.calculable = calculable;
    }

    public final Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        this.chart = chart;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    @Override
    public final Position getPosition(boolean create) {
        if (this.position == null && create) {
            this.position = new Position();
        }
        return this.position;
    }

    @Override
    public void setPosition(Position position) {
        this.position = position;
    }

    public final Number getMin() {
        return this.min;
    }

    public void setMin(Number min) {
        this.min = min;
    }

    public final Number getMax() {
        return this.max;
    }

    public void setMax(Number max) {
        this.max = max;
    }

    @Override
    public void setVisible(boolean visible) {
        this.show = visible;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    public Range getInRange() {
        return this.inRange;
    }

    public void setInRange(Range inRange) {
        this.inRange = inRange;
    }

    public Range getOutOfRange() {
        return this.outOfRange;
    }

    public void setOutOfRange(Range outOfRange) {
        this.outOfRange = outOfRange;
    }

    public static class Range
    implements ComponentProperty {
        private final List<String> colors = new ArrayList<String>();

        @Override
        public void encodeJSON(StringBuilder sb) {
            if (this.colors.isEmpty()) {
                return;
            }
            sb.append("\"color\": [");
            AtomicBoolean first = new AtomicBoolean(true);
            this.colors.forEach(c -> {
                if (c != null) {
                    if (first.get()) {
                        first.set(false);
                    } else {
                        sb.append(',');
                    }
                    sb.append(ComponentPart.escape(c));
                }
            });
            sb.append("]");
        }

        public void addColors(String ... colorsParam) {
            if (colorsParam == null) {
                return;
            }
            for (String color : colorsParam) {
                if (color == null) continue;
                this.colors.add(color);
            }
        }

        public List<String> getColors() {
            return this.colors;
        }
    }
}

