/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.ChartException;
import com.storedobject.chart.ChartType;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.DataType;
import com.storedobject.chart.InternalDataProvider;
import com.storedobject.chart.SelfPositioningSpecialChart;
import com.storedobject.chart.TreeDataProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class TreemapChart
extends SelfPositioningSpecialChart {
    private final List<TreeDataProvider> data = new ArrayList<TreeDataProvider>();
    private final TD td;

    public TreemapChart(TreeDataProvider ... data) {
        super(ChartType.Treemap, new AbstractDataProvider[0]);
        AbstractDataProvider[] abstractDataProviderArray = new AbstractDataProvider[1];
        this.td = new TD();
        abstractDataProviderArray[0] = this.td;
        super.setData(abstractDataProviderArray);
        this.addData(data);
    }

    @Override
    public final void setData(AbstractDataProvider<?> ... data) {
    }

    public List<TreeDataProvider> getTreemapData() {
        return this.data;
    }

    public void addData(TreeDataProvider ... data) {
        if (data != null) {
            this.data.addAll(Arrays.asList(data));
        }
    }

    public void removeData(TreeDataProvider ... data) {
        if (data != null) {
            this.data.removeAll(Arrays.asList(data));
        }
    }

    @Override
    public void validate() throws ChartException {
        super.validate();
        if (this.data.isEmpty()) {
            throw new ChartException("No data provided for " + this.className());
        }
    }

    @Override
    protected AbstractDataProvider<?> dataToEmbed() {
        return this.td;
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        ComponentPart.addComma(sb);
        ComponentPart.encode(sb, "leafDepth", 1);
    }

    private class TD
    implements AbstractDataProvider<Object>,
    InternalDataProvider {
        private int serial = -1;

        private TD() {
        }

        @Override
        public Stream<Object> stream() {
            return TreemapChart.this.data.stream().map(o -> o);
        }

        @Override
        public void encode(StringBuilder sb, Object value) {
            ((TreeDataProvider)value).encodeJSON(sb);
        }

        @Override
        public DataType getDataType() {
            return DataType.OBJECT;
        }

        @Override
        public void setSerial(int serial) {
            this.serial = serial;
        }

        @Override
        public int getSerial() {
            return this.serial;
        }
    }
}

