/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.ItemStyle;
import com.storedobject.chart.TextStyle;
import com.storedobject.chart.VisibleProperty;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

public interface TreeDataProvider
extends ComponentPart {
    public Number getValue();

    public Stream<? extends TreeDataProvider> getChildren();

    @Override
    default public void encodeJSON(StringBuilder sb) {
        ItemStyle itemStyle;
        Label label;
        String name = this.getName();
        if (name == null) {
            name = "Name?";
        }
        sb.append("{\"name\":").append(ComponentPart.escape(name));
        Number value = this.getValue();
        if (value != null) {
            sb.append(",\"value\":").append(value);
        }
        if ((label = this.getLabel(false)) != null) {
            label.encodeJSON(sb);
        }
        if ((itemStyle = this.getItemStyle(false)) != null) {
            itemStyle.encodeJSON(sb);
        }
        this.encode(sb, this.getChildren());
        sb.append('}');
    }

    private void encode(StringBuilder sb, Stream<? extends TreeDataProvider> children) {
        if (children == null) {
            return;
        }
        AtomicBoolean first = new AtomicBoolean(true);
        children.forEach(d -> {
            if (first.get()) {
                first.set(false);
                sb.append(",\"children\":[");
            } else {
                sb.append(',');
            }
            d.encodeJSON(sb);
        });
        if (!first.get()) {
            sb.append(']');
        }
    }

    @Override
    default public void validate() {
    }

    default public Label getLabel(boolean create) {
        return null;
    }

    default public ItemStyle getItemStyle(boolean create) {
        return null;
    }

    public static class Label
    extends TextStyle
    implements VisibleProperty {
        private boolean show = true;

        @Override
        public void setVisible(boolean visible) {
            this.show = visible;
        }

        @Override
        public boolean isVisible() {
            return this.show;
        }

        @Override
        public void encodeJSON(StringBuilder sb) {
            super.encodeJSON(sb);
            ComponentPart.addComma(sb);
            sb.append("\"show\":").append(this.show);
        }
    }
}

