/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.Component;
import com.storedobject.chart.ComponentPart;
import com.storedobject.chart.HasPosition;
import com.storedobject.chart.Position;
import com.storedobject.chart.TextStyle;
import com.storedobject.chart.VisiblePart;

public class Title
extends VisiblePart
implements Component,
HasPosition {
    private String text;
    private String subtext;
    private Position position;
    private TextStyle textStyle;
    private TextStyle subtextStyle;
    private int gap = -1;

    public Title(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void encodeJSON(StringBuilder sb) {
        super.encodeJSON(sb);
        TextStyle.OuterProperties op = new TextStyle.OuterProperties();
        ComponentPart.encode(sb, "text", this.text);
        String t = this.getSubtext();
        if (t != null) {
            sb.append(',');
            ComponentPart.encode(sb, "subtext", t);
            if (this.subtextStyle != null) {
                this.subtextStyle.save(op);
                ComponentPart.encode(sb, "subtextStyle", this.subtextStyle);
                this.subtextStyle.restore(op);
            }
        }
        ComponentPart.encode(sb, null, this.position);
        if (this.textStyle != null) {
            this.textStyle.save(op);
            ComponentPart.encode(sb, "textStyle", this.textStyle);
            this.textStyle.restore(op);
            if (op.background != null) {
                sb.append(",\"backgroundColor\":").append(op.background);
            }
            ComponentPart.encode(sb, null, op.padding);
            ComponentPart.encode(sb, null, op.border);
            if (op.alignment != null) {
                op.alignment.setPrefix("text");
                ComponentPart.encode(sb, null, op.alignment);
            }
        }
        if (this.gap > 0 && t != null) {
            ComponentPart.addComma(sb);
            sb.append("\"itemGap\":").append(this.gap);
        }
    }

    @Override
    public void validate() {
    }

    public String getSubtext() {
        return this.subtext;
    }

    public void setSubtext(String subtext) {
        this.subtext = subtext;
    }

    @Override
    public final Position getPosition(boolean create) {
        if (this.position == null && create) {
            this.position = new Position();
        }
        return this.position;
    }

    @Override
    public final void setPosition(Position position) {
        this.position = position;
    }

    public final TextStyle getTextStyle(boolean create) {
        if (this.textStyle == null && create) {
            this.textStyle = new TextStyle();
        }
        return this.textStyle;
    }

    public void setTextStyle(TextStyle textStyle) {
        this.textStyle = textStyle;
    }

    public final TextStyle getSubtextStyle(boolean create) {
        if (this.subtextStyle == null && create) {
            this.subtextStyle = new TextStyle();
        }
        return this.subtextStyle;
    }

    public void setSubtextStyle(TextStyle textStyle) {
        this.subtextStyle = textStyle;
    }

    public final int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }
}

