/*
 * Decompiled with CFR 0.152.
 */
package com.storedobject.chart;

import com.storedobject.chart.AbstractDataProvider;
import com.storedobject.chart.DataType;
import java.util.stream.Stream;

public class SerialData
implements AbstractDataProvider<Integer> {
    private final int start;
    private final int end;
    private final int step;
    private int serial;

    public SerialData(int start, int end) {
        this(start, end, 1);
    }

    public SerialData(int start, int end, int step) {
        int n = this.step = step == 0 ? 1 : step;
        if (this.step > 0) {
            this.start = Math.min(start, end);
            this.end = Math.max(start, end);
        } else {
            this.start = Math.max(start, end);
            this.end = Math.min(start, end);
        }
    }

    @Override
    public Stream<Integer> stream() {
        return Stream.iterate(this.start, i -> this.step > 1 ? i <= this.end : i >= this.end, i -> i + this.step);
    }

    @Override
    public final DataType getDataType() {
        return DataType.NUMBER;
    }

    @Override
    public final void setSerial(int serial) {
        this.serial = serial;
    }

    @Override
    public final int getSerial() {
        return this.serial;
    }
}

